/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import nl.flotsam.xeger.Xeger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class PactDslJsonRootValue
extends DslPart {
    private static final String USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS = "Use PactDslJsonArray for arrays";
    private static final String USE_PACT_DSL_JSON_BODY_FOR_OBJECTS = "Use PactDslJsonBody for objects";
    private static final String EXAMPLE = "Example \"";
    private Object value;

    public PactDslJsonRootValue() {
        super("");
    }

    @Override
    protected void putObject(DslPart object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void putArray(DslPart object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getBody() {
        return this.value;
    }

    @Override
    public PactDslJsonArray array(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray array() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public DslPart closeArray() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody arrayLike(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody arrayLike() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike(int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike(String name, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody object(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    public PactDslJsonBody object() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    public DslPart closeObject() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    public DslPart close() {
        return this;
    }

    public static PactDslJsonRootValue stringType() {
        return PactDslJsonRootValue.stringType(RandomStringUtils.randomAlphabetic((int)20));
    }

    public static PactDslJsonRootValue stringType(String example) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(example);
        value.setMatcher(value.matchType());
        return value;
    }

    public static PactDslJsonRootValue numberType() {
        return PactDslJsonRootValue.numberType(Long.parseLong(RandomStringUtils.randomNumeric((int)9)));
    }

    public static PactDslJsonRootValue numberType(Number number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher(value.matchType());
        return value;
    }

    public static PactDslJsonRootValue integerType() {
        return PactDslJsonRootValue.integerType(Long.parseLong(RandomStringUtils.randomNumeric((int)9)));
    }

    public static PactDslJsonRootValue integerType(Long number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher(value.matchType("integer"));
        return value;
    }

    public static PactDslJsonRootValue integerType(Integer number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher(value.matchType("integer"));
        return value;
    }

    public static PactDslJsonRootValue decimalType() {
        return PactDslJsonRootValue.decimalType(new BigDecimal(RandomStringUtils.randomNumeric((int)10)));
    }

    public static PactDslJsonRootValue decimalType(BigDecimal number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher(value.matchType("decimal"));
        return value;
    }

    public static PactDslJsonRootValue decimalType(Double number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher(value.matchType("decimal"));
        return value;
    }

    public static PactDslJsonRootValue booleanType() {
        return PactDslJsonRootValue.booleanType(true);
    }

    public static PactDslJsonRootValue booleanType(Boolean example) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(example);
        value.setMatcher(value.matchType());
        return value;
    }

    public static PactDslJsonRootValue stringMatcher(String regex, String value) {
        if (!value.matches(regex)) {
            throw new InvalidMatcherException(EXAMPLE + value + "\" does not match regular expression \"" + regex + "\"");
        }
        PactDslJsonRootValue rootValue = new PactDslJsonRootValue();
        rootValue.setValue(value);
        rootValue.setMatcher(rootValue.regexp(regex));
        return rootValue;
    }

    public static PactDslJsonRootValue stringMatcher(String regex) {
        return PactDslJsonRootValue.stringMatcher(regex, new Xeger(regex).generate());
    }

    public static PactDslJsonRootValue timestamp() {
        return PactDslJsonRootValue.timestamp(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue timestamp(String format) {
        return PactDslJsonRootValue.timestamp(format, new Date());
    }

    public static PactDslJsonRootValue timestamp(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(instance.format(example));
        value.setMatcher(value.matchTimestamp(format));
        return value;
    }

    public static PactDslJsonRootValue date() {
        return PactDslJsonRootValue.date(DateFormatUtils.ISO_DATE_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue date(String format) {
        return PactDslJsonRootValue.date(format, new Date());
    }

    public static PactDslJsonRootValue date(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(instance.format(example));
        value.setMatcher(value.matchDate(format));
        return value;
    }

    public static PactDslJsonRootValue time() {
        return PactDslJsonRootValue.time(DateFormatUtils.ISO_TIME_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue time(String format) {
        return PactDslJsonRootValue.time(format, new Date());
    }

    public static PactDslJsonRootValue time(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(instance.format(example));
        value.setMatcher(value.matchTime(format));
        return value;
    }

    public static PactDslJsonRootValue ipAddress() {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue("127.0.0.1");
        value.setMatcher(value.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return value;
    }

    public static PactDslJsonRootValue id() {
        return PactDslJsonRootValue.numberType();
    }

    public static PactDslJsonRootValue id(Long id) {
        return PactDslJsonRootValue.numberType(id);
    }

    public static PactDslJsonRootValue hexValue() {
        return PactDslJsonRootValue.hexValue(RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
    }

    public static PactDslJsonRootValue hexValue(String hexValue) {
        if (!hexValue.matches("[0-9a-fA-F]+")) {
            throw new InvalidMatcherException(EXAMPLE + hexValue + "\" is not a hexadecimal value");
        }
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(hexValue);
        value.setMatcher(value.regexp("[0-9a-fA-F]+"));
        return value;
    }

    public static PactDslJsonRootValue uuid() {
        return PactDslJsonRootValue.uuid(UUID.randomUUID().toString());
    }

    public static PactDslJsonRootValue uuid(UUID uuid) {
        return PactDslJsonRootValue.uuid(uuid.toString());
    }

    public static PactDslJsonRootValue uuid(String uuid) {
        if (!uuid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")) {
            throw new InvalidMatcherException(EXAMPLE + uuid + "\" is not an UUID");
        }
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(uuid);
        value.setMatcher(value.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setMatcher(Map<String, Object> matcher) {
        this.matchers.put("", matcher);
    }
}

