/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.model.Request;
import au.com.dius.pact.model.Response;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import nl.flotsam.xeger.Xeger;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public class PactDslResponse {
    private final ConsumerPactBuilder consumerPactBuilder;
    private PactDslRequestWithPath request;
    private int responseStatus = 200;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private String responseBody;
    private Map<String, Map<String, Object>> responseMatchers = new HashMap<String, Map<String, Object>>();

    public PactDslResponse(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath request) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.request = request;
    }

    public PactDslResponse status(int status) {
        this.responseStatus = status;
        return this;
    }

    public PactDslResponse headers(Map<String, String> headers) {
        this.responseHeaders.putAll(headers);
        return this;
    }

    public PactDslResponse body(String body) {
        this.responseBody = body;
        return this;
    }

    public PactDslResponse body(String body, String mimeType) {
        this.responseBody = body;
        this.responseHeaders.put("Content-Type", mimeType);
        return this;
    }

    public PactDslResponse body(String body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslResponse body(JSONObject body) {
        this.responseBody = body.toString();
        if (!this.responseHeaders.containsKey("Content-Type")) {
            this.responseHeaders.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslResponse body(DslPart body) {
        for (String matcherName : body.matchers.keySet()) {
            this.responseMatchers.put("$.body" + matcherName, body.matchers.get(matcherName));
        }
        this.responseBody = body.toString();
        if (!this.responseHeaders.containsKey("Content-Type")) {
            this.responseHeaders.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslResponse body(Document body) throws TransformerException {
        this.responseBody = ConsumerPactBuilder.xmlToString(body);
        if (!this.responseHeaders.containsKey("Content-Type")) {
            this.responseHeaders.put("Content-Type", ContentType.APPLICATION_XML.toString());
        }
        return this;
    }

    public PactDslResponse matchHeader(String header, String regexp) {
        return this.matchHeader(header, regexp, new Xeger(regexp).generate());
    }

    public PactDslResponse matchHeader(String header, String regexp, String headerExample) {
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("regex", regexp);
        this.responseMatchers.put("$.headers." + header, matcher);
        this.responseHeaders.put(header, headerExample);
        return this;
    }

    private void addInteraction() {
        this.consumerPactBuilder.getInteractions().add(new Interaction(this.request.description, this.request.state, new Request(this.request.requestMethod, this.request.path, PactReader.queryStringToMap((String)this.request.query, (boolean)false), this.request.requestHeaders, this.request.requestBody, this.request.requestMatchers), new Response(Integer.valueOf(this.responseStatus), this.responseHeaders, this.responseBody, this.responseMatchers)));
    }

    public PactFragment toFragment() {
        this.addInteraction();
        return new PactFragment(this.request.consumer, this.request.provider, (Seq<Interaction>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.consumerPactBuilder.getInteractions()).asScala()));
    }

    public PactDslRequestWithPath uponReceiving(String description) {
        this.addInteraction();
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.request, description);
    }

    public PactDslWithState given(String state) {
        this.addInteraction();
        return new PactDslWithState(this.consumerPactBuilder, this.request.consumer.getName(), this.request.provider.getName(), state);
    }
}

