/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import io.gatling.jsonpath.Parser$;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.flotsam.xeger.Xeger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONObject;

public class PactDslJsonBody
extends DslPart {
    private final JSONObject body = new JSONObject();

    public PactDslJsonBody() {
        super(".");
    }

    public PactDslJsonBody(String root, DslPart parent) {
        super(parent, root);
    }

    public String toString() {
        return this.body.toString();
    }

    @Override
    protected void putObject(DslPart object) {
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(matcherName, object.matchers.get(matcherName));
        }
        String name = StringUtils.strip((String)object.root, (String)".");
        Pattern p = Pattern.compile("\\['(.+)'\\]");
        Matcher matcher = p.matcher(name);
        if (matcher.matches()) {
            this.body.put(matcher.group(1), object.getBody());
        } else {
            this.body.put(name, object.getBody());
        }
    }

    @Override
    protected void putArray(DslPart object) {
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(matcherName, object.matchers.get(matcherName));
        }
        this.body.put(StringUtils.difference((String)this.root, (String)object.root), object.getBody());
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    public PactDslJsonBody stringValue(String name, String value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody numberValue(String name, Number value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody booleanValue(String name, Boolean value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody stringType(String name) {
        return this.stringType(name, RandomStringUtils.randomAlphabetic((int)20));
    }

    public PactDslJsonBody stringType(String name, String example) {
        this.body.put(name, (Object)example);
        this.matchers.put(this.matcherKey(name), this.matchType());
        return this;
    }

    private String matcherKey(String name) {
        String key = this.root + name;
        if (!name.matches(Parser$.MODULE$.FieldRegex().toString())) {
            key = StringUtils.strip((String)this.root, (String)".") + "['" + name + "']";
        }
        return key;
    }

    public PactDslJsonBody numberType(String name) {
        return this.numberType(name, Long.parseLong(RandomStringUtils.randomNumeric((int)10)));
    }

    public PactDslJsonBody numberType(String name, Number number) {
        this.body.put(name, (Object)number);
        this.matchers.put(this.matcherKey(name), this.matchType());
        return this;
    }

    public PactDslJsonBody integerType(String name) {
        return this.integerType(name, Long.parseLong(RandomStringUtils.randomNumeric((int)10)));
    }

    public PactDslJsonBody integerType(String name, Long number) {
        this.body.put(name, (Object)number);
        this.matchers.put(this.matcherKey(name), this.matchType("integer"));
        return this;
    }

    public PactDslJsonBody integerType(String name, Integer number) {
        this.body.put(name, (Object)number);
        this.matchers.put(this.matcherKey(name), this.matchType("integer"));
        return this;
    }

    public PactDslJsonBody realType(String name) {
        return this.realType(name, Double.parseDouble(RandomStringUtils.randomNumeric((int)10)));
    }

    public PactDslJsonBody realType(String name, Double number) {
        this.body.put(name, (Object)number);
        this.matchers.put(this.matcherKey(name), this.matchType("real"));
        return this;
    }

    public PactDslJsonBody booleanType(String name) {
        return this.booleanType(name, true);
    }

    public PactDslJsonBody booleanType(String name, Boolean example) {
        this.body.put(name, (Object)example);
        this.matchers.put(this.matcherKey(name), this.matchType());
        return this;
    }

    public PactDslJsonBody stringMatcher(String name, String regex, String value) {
        if (!value.matches(regex)) {
            throw new InvalidMatcherException("Example \"" + value + "\" does not match regular expression \"" + regex + "\"");
        }
        this.body.put(name, (Object)value);
        this.matchers.put(this.matcherKey(name), this.regexp(regex));
        return this;
    }

    public PactDslJsonBody stringMatcher(String name, String regex) {
        this.stringMatcher(name, regex, new Xeger(regex).generate());
        return this;
    }

    public PactDslJsonBody timestamp() {
        return this.timestamp("timestamp");
    }

    public PactDslJsonBody timestamp(String name) {
        this.body.put(name, (Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date()));
        this.matchers.put(this.matcherKey(name), this.matchTimestamp(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonBody timestamp(String name, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date()));
        this.matchers.put(this.matcherKey(name), this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonBody timestamp(String name, String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(example));
        this.matchers.put(this.matcherKey(name), this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonBody date() {
        return this.date("date");
    }

    public PactDslJsonBody date(String name) {
        this.body.put(name, (Object)DateFormatUtils.ISO_DATE_FORMAT.format(new Date()));
        this.matchers.put(this.matcherKey(name), this.matchDate(DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonBody date(String name, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date()));
        this.matchers.put(this.matcherKey(name), this.matchDate(format));
        return this;
    }

    public PactDslJsonBody date(String name, String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(example));
        this.matchers.put(this.matcherKey(name), this.matchDate(format));
        return this;
    }

    public PactDslJsonBody time() {
        return this.time("time");
    }

    public PactDslJsonBody time(String name) {
        this.body.put(name, (Object)DateFormatUtils.ISO_TIME_FORMAT.format(new Date()));
        this.matchers.put(this.matcherKey(name), this.matchTime(DateFormatUtils.ISO_TIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonBody time(String name, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date()));
        this.matchers.put(this.matcherKey(name), this.matchTime(format));
        return this;
    }

    public PactDslJsonBody time(String name, String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(example));
        this.matchers.put(this.matcherKey(name), this.matchTime(format));
        return this;
    }

    public PactDslJsonBody ipAddress(String name) {
        this.body.put(name, (Object)"127.0.0.1");
        this.matchers.put(this.matcherKey(name), this.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return this;
    }

    @Override
    public PactDslJsonBody object(String name) {
        String base = "." + name;
        if (!name.matches(Parser$.MODULE$.FieldRegex().toString())) {
            base = "['" + name + "']";
        }
        return new PactDslJsonBody(base + ".", this);
    }

    @Override
    public PactDslJsonBody object() {
        throw new UnsupportedOperationException("use the object(String name) form");
    }

    @Override
    public DslPart closeObject() {
        this.parent.putObject(this);
        return this.parent;
    }

    @Override
    public PactDslJsonArray array(String name) {
        return new PactDslJsonArray(this.matcherKey(name), this);
    }

    @Override
    public PactDslJsonArray array() {
        throw new UnsupportedOperationException("use the array(String name) form");
    }

    @Override
    public DslPart closeArray() {
        throw new UnsupportedOperationException("can't call closeArray on an Object");
    }

    @Override
    @Deprecated
    public PactDslJsonBody arrayLike(String name) {
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("match", "type");
        this.matchers.put(this.matcherKey(name), matcher);
        return new PactDslJsonBody(".", new PactDslJsonArray(this.matcherKey(name), this, true));
    }

    @Override
    @Deprecated
    public PactDslJsonBody arrayLike() {
        throw new UnsupportedOperationException("use the arrayLike(String name) form");
    }

    @Override
    public PactDslJsonBody eachLike(String name) {
        this.matchers.put(this.matcherKey(name), this.matchMin(0));
        return new PactDslJsonBody(".", new PactDslJsonArray(this.matcherKey(name), this, true));
    }

    @Override
    public PactDslJsonBody eachLike() {
        throw new UnsupportedOperationException("use the eachLike(String name) form");
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size) {
        this.matchers.put(this.matcherKey(name), this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), this, true);
        return new PactDslJsonBody(".", parent);
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size) {
        throw new UnsupportedOperationException("use the minArrayLike(String name, Integer size) form");
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size) {
        this.matchers.put(this.matcherKey(name), this.matchMax(size));
        return new PactDslJsonBody(".", new PactDslJsonArray(this.matcherKey(name), this, true));
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size) {
        throw new UnsupportedOperationException("use the maxArrayLike(String name, Integer size) form");
    }

    public PactDslJsonBody id() {
        return this.id("id");
    }

    public PactDslJsonBody id(String name) {
        this.body.put(name, Long.parseLong(RandomStringUtils.randomNumeric((int)10)));
        this.matchers.put(this.matcherKey(name), this.matchType());
        return this;
    }

    public PactDslJsonBody id(String name, Long id) {
        this.body.put(name, (Object)id);
        this.matchers.put(this.matcherKey(name), this.matchType());
        return this;
    }

    public PactDslJsonBody hexValue(String name) {
        return this.hexValue(name, RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
    }

    public PactDslJsonBody hexValue(String name, String hexValue) {
        if (!hexValue.matches("[0-9a-fA-F]+")) {
            throw new InvalidMatcherException("Example \"" + hexValue + "\" is not a hexadecimal value");
        }
        this.body.put(name, (Object)hexValue);
        this.matchers.put(this.matcherKey(name), this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    @Deprecated
    public PactDslJsonBody guid(String name) {
        return this.uuid(name);
    }

    @Deprecated
    public PactDslJsonBody guid(String name, UUID uuid) {
        return this.uuid(name, uuid);
    }

    @Deprecated
    public PactDslJsonBody guid(String name, String uuid) {
        return this.uuid(name, uuid);
    }

    public PactDslJsonBody uuid(String name) {
        return this.uuid(name, UUID.randomUUID().toString());
    }

    public PactDslJsonBody uuid(String name, UUID uuid) {
        return this.uuid(name, uuid.toString());
    }

    public PactDslJsonBody uuid(String name, String uuid) {
        if (!uuid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")) {
            throw new InvalidMatcherException("Example \"" + uuid + "\" is not an UUID");
        }
        this.body.put(name, (Object)uuid);
        this.matchers.put(this.matcherKey(name), this.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return this;
    }
}

