/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.DslPart;
import au.com.dius.pact.consumer.PactDslJsonBody;
import java.util.Date;
import java.util.UUID;
import nl.flotsam.xeger.Xeger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONArray;

public class PactDslJsonArray
extends DslPart {
    private final JSONArray body;
    private boolean wildCard;

    public PactDslJsonArray() {
        this("", null, false);
    }

    public PactDslJsonArray(String root, DslPart parent) {
        this(root, parent, false);
    }

    public PactDslJsonArray(String root, DslPart parent, boolean wildCard) {
        super(parent, root);
        this.wildCard = wildCard;
        this.body = new JSONArray();
    }

    @Override
    public DslPart closeArray() {
        this.parent.putArray(this);
        return this.parent;
    }

    @Override
    public PactDslJsonBody arrayLike(String name) {
        throw new UnsupportedOperationException("use the arrayLike() form");
    }

    @Override
    public PactDslJsonBody arrayLike() {
        PactDslJsonArray parent = new PactDslJsonArray(this.root, this, true);
        return new PactDslJsonBody(".", parent);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the minArrayLike(Integer size) form");
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size) {
        this.matchers.put(this.root + this.appendArrayIndex(1), this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray("", this, true);
        return new PactDslJsonBody(".", parent);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the maxArrayLike(Integer size) form");
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size) {
        this.matchers.put(this.root + this.appendArrayIndex(1), this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray("", this, true);
        return new PactDslJsonBody(".", parent);
    }

    @Override
    protected void putObject(DslPart object) {
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(this.root + this.appendArrayIndex(1) + matcherName, object.matchers.get(matcherName));
        }
        this.body.put(object.getBody());
    }

    @Override
    protected void putArray(DslPart object) {
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(this.root + this.appendArrayIndex(1) + matcherName, object.matchers.get(matcherName));
        }
        this.body.put(object.getBody());
    }

    @Override
    protected Object getBody() {
        return this.body;
    }

    public PactDslJsonArray stringValue(String value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray string(String value) {
        return this.stringValue(value);
    }

    public PactDslJsonArray numberValue(Number value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray number(Number value) {
        return this.numberValue(value);
    }

    public PactDslJsonArray booleanValue(Boolean value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray stringType() {
        this.body.put((Object)RandomStringUtils.randomAlphabetic((int)20));
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray numberType() {
        return this.numberType(Long.parseLong(RandomStringUtils.randomNumeric((int)10)));
    }

    public PactDslJsonArray numberType(Number number) {
        this.body.put((Object)number);
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchType("type"));
        return this;
    }

    public PactDslJsonArray integerType() {
        return this.integerType(Long.parseLong(RandomStringUtils.randomNumeric((int)10)));
    }

    public PactDslJsonArray integerType(Long number) {
        this.body.put((Object)number);
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchType("integer"));
        return this;
    }

    public PactDslJsonArray realType() {
        return this.realType(Double.parseDouble(RandomStringUtils.randomNumeric((int)10)) / 100.0);
    }

    public PactDslJsonArray realType(Double number) {
        this.body.put((Object)number);
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchType("real"));
        return this;
    }

    public PactDslJsonArray booleanType(String name) {
        this.body.put(true);
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray stringMatcher(String regex, String value) {
        this.body.put((Object)value);
        this.matchers.put(this.root + this.appendArrayIndex(0), this.regexp(regex));
        return this;
    }

    public PactDslJsonArray stringMatcher(String regex) {
        this.stringMatcher(regex, new Xeger(regex).generate());
        return this;
    }

    public PactDslJsonArray timestamp() {
        this.body.put((Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date()));
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchTimestamp(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray timestamp(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonArray date() {
        this.body.put((Object)DateFormatUtils.ISO_DATE_FORMAT.format(new Date()));
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchDate(DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray date(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchDate(format));
        return this;
    }

    public PactDslJsonArray time() {
        this.body.put((Object)DateFormatUtils.ISO_TIME_FORMAT.format(new Date()));
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchTime(DateFormatUtils.ISO_TIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray time(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchTime(format));
        return this;
    }

    public PactDslJsonArray ipAddress() {
        this.body.put((Object)"127.0.0.1");
        this.matchers.put(this.root + this.appendArrayIndex(0), this.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return this;
    }

    @Override
    public PactDslJsonBody object(String name) {
        throw new UnsupportedOperationException("use the object() form");
    }

    @Override
    public PactDslJsonBody object() {
        return new PactDslJsonBody(".", this);
    }

    @Override
    public DslPart closeObject() {
        throw new UnsupportedOperationException("can't call closeObject on an Array");
    }

    @Override
    public PactDslJsonArray array(String name) {
        throw new UnsupportedOperationException("use the array() form");
    }

    @Override
    public PactDslJsonArray array() {
        return new PactDslJsonArray("", this);
    }

    public PactDslJsonArray id() {
        this.body.put((Object)RandomStringUtils.randomNumeric((int)10));
        this.matchers.put(this.root + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray hexValue() {
        return this.hexValue(RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
    }

    public PactDslJsonArray hexValue(String hexValue) {
        this.body.put((Object)hexValue);
        this.matchers.put(this.root + this.appendArrayIndex(0), this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    public PactDslJsonArray guid() {
        return this.guid(UUID.randomUUID().toString());
    }

    public PactDslJsonArray guid(String uuid) {
        this.body.put((Object)uuid);
        this.matchers.put(this.root + this.appendArrayIndex(0), this.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return this;
    }

    public PactDslJsonArray template(DslPart template) {
        this.putObject(template);
        return this;
    }

    public PactDslJsonArray template(DslPart template, int occurrences) {
        for (int i = 0; i < occurrences; ++i) {
            this.template(template);
        }
        return this;
    }

    public String toString() {
        return this.body.toString();
    }

    private String appendArrayIndex(Integer offset) {
        String index = "*";
        if (!this.wildCard) {
            index = String.valueOf(this.body.length() - 1 + offset);
        }
        return "[" + index + "]";
    }
}

