/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonRootValue;
import au.com.dius.pact.consumer.dsl.PactDslRequestBase;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithoutPath;
import au.com.dius.pact.consumer.dsl.PactDslResponse;
import au.com.dius.pact.consumer.dsl.QuoteUtil;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.Generators;
import au.com.dius.pact.core.model.generators.ProviderStateGenerator;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRules;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import com.mifmif.common.regex.Generex;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class PactDslRequestWithPath
extends PactDslRequestBase {
    private static final String CONTENT_TYPE = "Content-Type";
    private final ConsumerPactBuilder consumerPactBuilder;
    Consumer consumer;
    Provider provider;
    List<ProviderState> state;
    String description;
    String path = "/";
    private final PactDslResponse defaultResponseValues;

    PactDslRequestWithPath(ConsumerPactBuilder consumerPactBuilder, String consumerName, String providerName, List<ProviderState> state, String description, String path, String requestMethod, Map<String, List<String>> requestHeaders, Map<String, List<String>> query, OptionalBody requestBody, MatchingRules requestMatchers, Generators requestGenerators, PactDslRequestWithoutPath defaultRequestValues, PactDslResponse defaultResponseValues) {
        super(defaultRequestValues);
        this.consumerPactBuilder = consumerPactBuilder;
        this.requestMatchers = requestMatchers;
        this.consumer = new Consumer(consumerName);
        this.provider = new Provider(providerName);
        this.state = state;
        this.description = description;
        this.path = path;
        this.requestMethod = requestMethod;
        this.requestHeaders = requestHeaders;
        this.query = query;
        this.requestBody = requestBody;
        this.requestMatchers = requestMatchers;
        this.requestGenerators = requestGenerators;
        this.defaultResponseValues = defaultResponseValues;
        this.setupDefaultValues();
    }

    PactDslRequestWithPath(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath existing, String description, PactDslRequestWithoutPath defaultRequestValues, PactDslResponse defaultResponseValues) {
        super(defaultRequestValues);
        this.requestMethod = "GET";
        this.consumerPactBuilder = consumerPactBuilder;
        this.consumer = existing.consumer;
        this.provider = existing.provider;
        this.state = existing.state;
        this.description = description;
        this.defaultResponseValues = defaultResponseValues;
        this.path = existing.path;
        this.setupDefaultValues();
    }

    public PactDslRequestWithPath method(String method) {
        this.requestMethod = method;
        return this;
    }

    public PactDslRequestWithPath headers(String firstHeaderName, String firstHeaderValue, String ... headerNameValuePairs) {
        if (headerNameValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Pair key value should be provided, but there is one key without value.");
        }
        this.requestHeaders.put(firstHeaderName, Collections.singletonList(firstHeaderValue));
        for (int i = 0; i < headerNameValuePairs.length; i += 2) {
            this.requestHeaders.put(headerNameValuePairs[i], Collections.singletonList(headerNameValuePairs[i + 1]));
        }
        return this;
    }

    public PactDslRequestWithPath headers(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.requestHeaders.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        return this;
    }

    public PactDslRequestWithPath query(String query) {
        this.query = PactReaderKt.queryStringToMap((String)query, (boolean)false);
        return this;
    }

    public PactDslRequestWithPath encodedQuery(String query) {
        this.query = PactReaderKt.queryStringToMap((String)query, (boolean)true);
        return this;
    }

    public PactDslRequestWithPath body(String body) {
        this.requestBody = OptionalBody.body((byte[])body.getBytes());
        return this;
    }

    public PactDslRequestWithPath body(String body, String contentType) {
        return this.body(body, ContentType.parse((String)contentType));
    }

    public PactDslRequestWithPath body(String body, ContentType contentType) {
        Charset charset = contentType.getCharset() == null ? Charset.defaultCharset() : contentType.getCharset();
        this.requestBody = OptionalBody.body((byte[])body.getBytes(charset), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(contentType.toString()));
        this.requestHeaders.put(CONTENT_TYPE, Collections.singletonList(contentType.toString()));
        return this;
    }

    public PactDslRequestWithPath body(Supplier<String> body) {
        this.requestBody = OptionalBody.body((byte[])body.get().getBytes());
        return this;
    }

    public PactDslRequestWithPath body(Supplier<String> body, String contentType) {
        return this.body(body, ContentType.parse((String)contentType));
    }

    public PactDslRequestWithPath body(Supplier<String> body, ContentType contentType) {
        Charset charset = contentType.getCharset() == null ? Charset.defaultCharset() : contentType.getCharset();
        this.requestBody = OptionalBody.body((byte[])body.get().getBytes(charset), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(contentType.toString()));
        this.requestHeaders.put(CONTENT_TYPE, Collections.singletonList(contentType.toString()));
        return this;
    }

    public PactDslRequestWithPath bodyWithSingleQuotes(String body) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body);
    }

    public PactDslRequestWithPath bodyWithSingleQuotes(String body, String contentType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, contentType);
    }

    public PactDslRequestWithPath bodyWithSingleQuotes(String body, ContentType contentType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, contentType);
    }

    public PactDslRequestWithPath body(JSONObject body) {
        this.requestBody = OptionalBody.body((byte[])body.toString().getBytes(), (au.com.dius.pact.core.model.ContentType)au.com.dius.pact.core.model.ContentType.Companion.getJSON());
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, Collections.singletonList(ContentType.APPLICATION_JSON.toString()));
        }
        return this;
    }

    public PactDslRequestWithPath body(DslPart body) {
        DslPart parent = body.close();
        if (parent instanceof PactDslJsonRootValue) {
            ((PactDslJsonRootValue)parent).setEncodeJson(true);
        }
        this.requestMatchers.addCategory(parent.getMatchers());
        this.requestGenerators.addGenerators(parent.generators);
        this.requestBody = parent.getBody() != null ? OptionalBody.body((byte[])parent.getBody().toString().getBytes(), (au.com.dius.pact.core.model.ContentType)au.com.dius.pact.core.model.ContentType.Companion.getJSON()) : OptionalBody.nullBody();
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, Collections.singletonList(ContentType.APPLICATION_JSON.toString()));
        }
        return this;
    }

    public PactDslRequestWithPath body(Document body) throws TransformerException {
        this.requestBody = OptionalBody.body((byte[])ConsumerPactBuilder.xmlToString(body).getBytes(), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(ContentType.APPLICATION_XML.toString()));
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, Collections.singletonList(ContentType.APPLICATION_XML.toString()));
        }
        return this;
    }

    public PactDslRequestWithPath path(String path) {
        this.path = path;
        return this;
    }

    public PactDslRequestWithPath matchPath(String pathRegex) {
        return this.matchPath(pathRegex, new Generex(pathRegex).random());
    }

    public PactDslRequestWithPath matchPath(String pathRegex, String path) {
        this.requestMatchers.addCategory("path").addRule((MatchingRule)new RegexMatcher(pathRegex));
        this.path = path;
        return this;
    }

    public PactDslRequestWithPath matchHeader(String header, String regex) {
        return this.matchHeader(header, regex, new Generex(regex).random());
    }

    public PactDslRequestWithPath matchHeader(String header, String regex, String headerExample) {
        this.requestMatchers.addCategory("header").setRule(header, (MatchingRule)new RegexMatcher(regex));
        this.requestHeaders.put(header, Collections.singletonList(headerExample));
        return this;
    }

    public PactDslResponse willRespondWith() {
        return new PactDslResponse(this.consumerPactBuilder, this, this.defaultRequestValues, this.defaultResponseValues);
    }

    public PactDslRequestWithPath matchQuery(String parameter, String regex) {
        return this.matchQuery(parameter, regex, new Generex(regex).random());
    }

    public PactDslRequestWithPath matchQuery(String parameter, String regex, String example) {
        this.requestMatchers.addCategory("query").addRule(parameter, (MatchingRule)new RegexMatcher(regex));
        this.query.put(parameter, Collections.singletonList(example));
        return this;
    }

    public PactDslRequestWithPath matchQuery(String parameter, String regex, List<String> example) {
        this.requestMatchers.addCategory("query").addRule(parameter, (MatchingRule)new RegexMatcher(regex));
        this.query.put(parameter, example);
        return this;
    }

    public PactDslRequestWithPath withFileUpload(String partName, String fileName, String fileContentType, byte[] data) throws IOException {
        this.setupFileUpload(partName, fileName, fileContentType, data);
        return this;
    }

    public PactDslRequestWithPath headerFromProviderState(String name, String expression, String example) {
        this.requestGenerators.addGenerator(Category.HEADER, name, (Generator)new ProviderStateGenerator(expression));
        this.requestHeaders.put(name, Collections.singletonList(example));
        return this;
    }

    public PactDslRequestWithPath queryParameterFromProviderState(String name, String expression, String example) {
        this.requestGenerators.addGenerator(Category.QUERY, name, (Generator)new ProviderStateGenerator(expression));
        this.query.put(name, Collections.singletonList(example));
        return this;
    }

    public PactDslRequestWithPath pathFromProviderState(String expression, String example) {
        this.requestGenerators.addGenerator(Category.PATH, (Generator)new ProviderStateGenerator(expression));
        this.path = example;
        return this;
    }

    public PactDslRequestWithPath queryMatchingDate(String field, String pattern, String example) {
        return (PactDslRequestWithPath)this.queryMatchingDateBase(field, pattern, example);
    }

    public PactDslRequestWithPath queryMatchingDate(String field, String pattern) {
        return (PactDslRequestWithPath)this.queryMatchingDateBase(field, pattern, null);
    }

    public PactDslRequestWithPath queryMatchingTime(String field, String pattern, String example) {
        return (PactDslRequestWithPath)this.queryMatchingTimeBase(field, pattern, example);
    }

    public PactDslRequestWithPath queryMatchingTime(String field, String pattern) {
        return (PactDslRequestWithPath)this.queryMatchingTimeBase(field, pattern, null);
    }

    public PactDslRequestWithPath queryMatchingDatetime(String field, String pattern, String example) {
        return (PactDslRequestWithPath)this.queryMatchingDatetimeBase(field, pattern, example);
    }

    public PactDslRequestWithPath queryMatchingDatetime(String field, String pattern) {
        return (PactDslRequestWithPath)this.queryMatchingDatetimeBase(field, pattern, null);
    }

    public PactDslRequestWithPath queryMatchingISODate(String field, String example) {
        return (PactDslRequestWithPath)this.queryMatchingDateBase(field, DateFormatUtils.ISO_DATE_FORMAT.getPattern(), example);
    }

    public PactDslRequestWithPath queryMatchingISODate(String field) {
        return this.queryMatchingISODate(field, null);
    }

    public PactDslRequestWithPath queryMatchingISOTime(String field, String example) {
        return (PactDslRequestWithPath)this.queryMatchingTimeBase(field, DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern(), example);
    }

    public PactDslRequestWithPath queryMatchingTime(String field) {
        return this.queryMatchingISOTime(field, null);
    }

    public PactDslRequestWithPath queryMatchingISODatetime(String field, String example) {
        return (PactDslRequestWithPath)this.queryMatchingDatetimeBase(field, DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), example);
    }

    public PactDslRequestWithPath queryMatchingISODatetime(String field) {
        return this.queryMatchingISODatetime(field, null);
    }
}

