/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.ConsumerPactRunnerKt;
import au.com.dius.pact.consumer.DefaultRequestValues;
import au.com.dius.pact.consumer.DefaultResponseValues;
import au.com.dius.pact.consumer.MockServer;
import au.com.dius.pact.consumer.Pact;
import au.com.dius.pact.consumer.PactFolder;
import au.com.dius.pact.consumer.PactVerification;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.consumer.PactVerifications;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithoutPath;
import au.com.dius.pact.consumer.dsl.PactDslResponse;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.junit.JUnitTestSupport;
import au.com.dius.pact.model.MockProviderConfig;
import au.com.dius.pact.model.PactSpecVersion;
import au.com.dius.pact.model.RequestResponsePact;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BaseProviderRule
extends ExternalResource {
    protected final String provider;
    protected final Object target;
    protected MockProviderConfig config;
    private Map<String, RequestResponsePact> pacts;
    private MockServer mockServer;

    public BaseProviderRule(Object target, String provider, String hostInterface, Integer port, PactSpecVersion pactVersion) {
        this.target = target;
        this.provider = provider;
        this.config = MockProviderConfig.httpConfig((String)(StringUtils.isEmpty((CharSequence)hostInterface) ? "127.0.0.1" : hostInterface), (int)(port == null ? 0 : port), (PactSpecVersion)pactVersion);
    }

    public MockProviderConfig getConfig() {
        return this.config;
    }

    public MockServer getMockServer() {
        return this.mockServer;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerifications pactVerifications = (PactVerifications)description.getAnnotation(PactVerifications.class);
                if (pactVerifications != null) {
                    BaseProviderRule.this.evaluatePactVerifications(pactVerifications, base);
                    return;
                }
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                Map<String, RequestResponsePact> pacts = BaseProviderRule.this.getPacts(pactDef.fragment());
                Optional<RequestResponsePact> pact = pactDef.value().length == 1 && StringUtils.isEmpty((CharSequence)pactDef.value()[0]) ? pacts.values().stream().findFirst() : Arrays.stream(pactDef.value()).map(pacts::get).filter(Objects::nonNull).findFirst();
                if (!pact.isPresent()) {
                    base.evaluate();
                    return;
                }
                PactFolder pactFolder = BaseProviderRule.this.target.getClass().getAnnotation(PactFolder.class);
                PactVerificationResult result = BaseProviderRule.this.runPactTest(base, pact.get(), pactFolder);
                BaseProviderRule.this.validateResult(result, pactDef);
            }
        };
    }

    private void evaluatePactVerifications(PactVerifications pactVerifications, Statement base) throws Throwable {
        RequestResponsePact pact;
        Optional<PactVerification> possiblePactVerification = this.findPactVerification(pactVerifications);
        if (!possiblePactVerification.isPresent()) {
            base.evaluate();
            return;
        }
        PactVerification pactVerification = possiblePactVerification.get();
        Optional<Method> possiblePactMethod = this.findPactMethod(pactVerification);
        if (!possiblePactMethod.isPresent()) {
            throw new UnsupportedOperationException("Could not find method with @Pact for the provider " + this.provider);
        }
        Method method = possiblePactMethod.get();
        Pact pactAnnotation = method.getAnnotation(Pact.class);
        PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)pactAnnotation.consumer()).hasPactWith(this.provider);
        try {
            pact = (RequestResponsePact)method.invoke(this.target, dslBuilder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke pact method", e);
        }
        PactFolder pactFolder = this.target.getClass().getAnnotation(PactFolder.class);
        PactVerificationResult result = this.runPactTest(base, pact, pactFolder);
        this.validateResult(result, pactVerification);
    }

    private Optional<PactVerification> findPactVerification(PactVerifications pactVerifications) {
        PactVerification[] pactVerificationValues = pactVerifications.value();
        return Arrays.stream(pactVerificationValues).filter(p -> {
            String[] providers = p.value();
            if (providers.length != 1) {
                throw new IllegalArgumentException("Each @PactVerification must specify one and only provider when using @PactVerifications");
            }
            String provider = providers[0];
            return provider.equals(this.provider);
        }).findFirst();
    }

    private Optional<Method> findPactMethod(PactVerification pactVerification) {
        String pactFragment = pactVerification.fragment();
        for (Method method : this.target.getClass().getMethods()) {
            Pact pact = method.getAnnotation(Pact.class);
            if (pact == null || !pact.provider().equals(this.provider) || !pactFragment.isEmpty() && !pactFragment.equals(method.getName())) continue;
            this.validatePactSignature(method);
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private void validatePactSignature(Method method) {
        boolean hasValidPactSignature;
        boolean bl = hasValidPactSignature = RequestResponsePact.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(PactDslWithProvider.class);
        if (!hasValidPactSignature) {
            throw new UnsupportedOperationException("Method " + method.getName() + " does not conform required method signature 'public RequestResponsePact xxx(PactDslWithProvider builder)'");
        }
    }

    private PactVerificationResult runPactTest(Statement base, RequestResponsePact pact, PactFolder pactFolder) {
        return ConsumerPactRunnerKt.runConsumerTest((RequestResponsePact)pact, (MockProviderConfig)this.config, (mockServer, context) -> {
            this.mockServer = mockServer;
            base.evaluate();
            this.mockServer = null;
            if (pactFolder != null) {
                context.setPactFolder(pactFolder.value());
            }
        });
    }

    @Deprecated
    protected void validateResult(PactVerificationResult result, PactVerification pactVerification) throws Throwable {
        JUnitTestSupport.validateMockServerResult((PactVerificationResult)result);
    }

    protected Map<String, RequestResponsePact> getPacts(String fragment) {
        if (this.pacts == null) {
            this.pacts = new HashMap<String, RequestResponsePact>();
            for (Method m : this.target.getClass().getMethods()) {
                Pact pactAnnotation;
                if (!JUnitTestSupport.conformsToSignature((Method)m) || !this.methodMatchesFragment(m, fragment) || !StringUtils.isEmpty((CharSequence)(pactAnnotation = m.getAnnotation(Pact.class)).provider()) && !this.provider.equals(pactAnnotation.provider())) continue;
                PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)pactAnnotation.consumer()).hasPactWith(this.provider);
                this.updateAnyDefaultValues(dslBuilder);
                try {
                    RequestResponsePact pact = (RequestResponsePact)m.invoke(this.target, dslBuilder);
                    this.pacts.put(this.provider, pact);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke pact method", e);
                }
            }
        }
        return this.pacts;
    }

    private void updateAnyDefaultValues(PactDslWithProvider dslBuilder) {
        for (Method m : this.target.getClass().getMethods()) {
            if (m.isAnnotationPresent(DefaultRequestValues.class)) {
                this.setupDefaultRequestValues(dslBuilder, m);
                continue;
            }
            if (!m.isAnnotationPresent(DefaultResponseValues.class)) continue;
            this.setupDefaultResponseValues(dslBuilder, m);
        }
    }

    private void setupDefaultRequestValues(PactDslWithProvider dslBuilder, Method m) {
        PactDslRequestWithoutPath defaults;
        if (m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(PactDslRequestWithoutPath.class)) {
            defaults = dslBuilder.uponReceiving("defaults");
            try {
                m.invoke(this.target, defaults);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke default request method", e);
            }
        } else {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public void " + m.getName() + "(PactDslRequestWithoutPath defaultRequest)'");
        }
        dslBuilder.setDefaultRequestValues(defaults);
    }

    private void setupDefaultResponseValues(PactDslWithProvider dslBuilder, Method m) {
        PactDslResponse defaults;
        if (m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(PactDslResponse.class)) {
            defaults = new PactDslResponse(dslBuilder.getConsumerPactBuilder(), null, null, null);
            try {
                m.invoke(this.target, defaults);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke default response method", e);
            }
        } else {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public void " + m.getName() + "(PactDslResponse defaultResponse)'");
        }
        dslBuilder.setDefaultResponseValues(defaults);
    }

    private boolean methodMatchesFragment(Method m, String fragment) {
        return StringUtils.isEmpty((CharSequence)fragment) || m.getName().equals(fragment);
    }

    public String getUrl() {
        return this.mockServer == null ? null : this.mockServer.getUrl();
    }

    public Integer getPort() {
        return this.mockServer == null ? null : Integer.valueOf(this.mockServer.getPort());
    }
}

