/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.Pact;
import au.com.dius.pact.consumer.PactError;
import au.com.dius.pact.consumer.PactVerification;
import au.com.dius.pact.consumer.PactVerified$;
import au.com.dius.pact.consumer.TestRun;
import au.com.dius.pact.consumer.VerificationResult;
import au.com.dius.pact.model.MockProviderConfig;
import au.com.dius.pact.model.PactFragment;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class PactRule
extends ExternalResource {
    public static VerificationResult PACT_VERIFIED = PactVerified$.MODULE$;
    private Map<String, PactFragment> fragments;
    private Object target;
    final MockProviderConfig config;

    public PactRule(String host, int port, Object target) {
        this.config = new MockProviderConfig(port, host);
        this.target = target;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                PactFragment fragment = PactRule.this.getPacts().get(pactDef.value());
                if (fragment == null) {
                    throw new UnsupportedOperationException("Fragment not found: " + pactDef.value());
                }
                VerificationResult result = fragment.runConsumer(PactRule.this.config, new TestRun(){

                    public void run(MockProviderConfig config) {
                        try {
                            base.evaluate();
                        }
                        catch (Throwable e) {
                            Assert.fail((String)("error thrown: " + e));
                        }
                    }
                });
                if (result instanceof PactError) {
                    throw new RuntimeException(((PactError)result).error());
                }
                Assert.assertEquals((Object)PACT_VERIFIED, (Object)result);
            }
        };
    }

    protected Map<String, PactFragment> getPacts() {
        if (this.fragments == null) {
            this.fragments = new HashMap<String, PactFragment>();
            for (Method m : this.target.getClass().getMethods()) {
                if (!this.conformsToSigniture(m)) continue;
                Pact pact = m.getAnnotation(Pact.class);
                ConsumerPactBuilder.PactDslWithProvider.PactDslWithState dslBuilder = ConsumerPactBuilder.consumer(pact.consumer()).hasPactWith(pact.provider()).given(pact.state());
                try {
                    this.fragments.put(pact.state(), (PactFragment)m.invoke(this.target, dslBuilder));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.fragments;
    }

    private boolean conformsToSigniture(Method m) {
        boolean conforms;
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = conforms = pact != null && PactFragment.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(ConsumerPactBuilder.PactDslWithProvider.PactDslWithState.class);
        if (!conforms && pact != null) {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature " + "'public PactFragment xxx(PactDslWithState builder)'");
        }
        return conforms;
    }
}

