/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.DslPart;
import au.com.dius.pact.consumer.PactDslJsonArray;
import java.util.Date;
import java.util.UUID;
import nl.flotsam.xeger.Xeger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONObject;

public class PactDslJsonBody
extends DslPart {
    private final JSONObject body = new JSONObject();

    public PactDslJsonBody() {
        super("$.body");
    }

    public PactDslJsonBody(String root, DslPart parent) {
        super(parent, root);
    }

    public String toString() {
        return this.body.toString();
    }

    @Override
    protected void putObject(DslPart object) {
        String name = StringUtils.difference((String)(this.root + "."), (String)object.root);
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(matcherName, object.matchers.get(matcherName));
        }
        this.body.put(name, object.getBody());
    }

    @Override
    protected void putArray(DslPart object) {
        String name = StringUtils.difference((String)(this.root + "."), (String)object.root);
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(matcherName, object.matchers.get(matcherName));
        }
        this.body.put(name, object.getBody());
    }

    @Override
    protected Object getBody() {
        return this.body;
    }

    public PactDslJsonBody stringValue(String name, String value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody numberValue(String name, Number value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody booleanValue(String name, Boolean value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody stringType(String name) {
        this.body.put(name, (Object)RandomStringUtils.randomAlphabetic((int)20));
        this.matchers.put(this.root + "." + name, this.matchType());
        return this;
    }

    public PactDslJsonBody numberType(String name) {
        this.body.put(name, Long.parseLong(RandomStringUtils.randomNumeric((int)10)));
        this.matchers.put(this.root + "." + name, this.matchType());
        return this;
    }

    public PactDslJsonBody booleanType(String name) {
        this.body.put(name, true);
        this.matchers.put(this.root + "." + name, this.matchType());
        return this;
    }

    public PactDslJsonBody stringMatcher(String name, String regex, String value) {
        this.body.put(name, (Object)value);
        this.matchers.put(this.root + "." + name, this.regexp(regex));
        return this;
    }

    public PactDslJsonBody stringMatcher(String name, String regex) {
        this.stringMatcher(name, regex, new Xeger(regex).generate());
        return this;
    }

    public PactDslJsonBody timestamp() {
        return this.timestamp("timestamp");
    }

    public PactDslJsonBody timestamp(String name) {
        this.body.put(name, (Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date()));
        this.matchers.put(this.root + "." + name, this.matchTimestamp(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonBody timestamp(String name, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date()));
        this.matchers.put(this.root + "." + name, this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonBody date() {
        return this.date("date");
    }

    public PactDslJsonBody date(String name) {
        this.body.put(name, (Object)DateFormatUtils.ISO_DATE_FORMAT.format(new Date()));
        this.matchers.put(this.root + "." + name, this.matchDate(DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonBody date(String name, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date()));
        this.matchers.put(this.root + "." + name, this.matchDate(format));
        return this;
    }

    public PactDslJsonBody time() {
        return this.time("time");
    }

    public PactDslJsonBody time(String name) {
        this.body.put(name, (Object)DateFormatUtils.ISO_TIME_FORMAT.format(new Date()));
        this.matchers.put(this.root + "." + name, this.matchTime(DateFormatUtils.ISO_TIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonBody time(String name, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date()));
        this.matchers.put(this.root + "." + name, this.matchTime(format));
        return this;
    }

    public PactDslJsonBody ipAddress(String name) {
        this.body.put(name, (Object)"127.0.0.1");
        this.matchers.put(this.root + "." + name, this.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return this;
    }

    @Override
    public PactDslJsonBody object(String name) {
        return new PactDslJsonBody(this.root + "." + name, this);
    }

    @Override
    public PactDslJsonBody object() {
        throw new UnsupportedOperationException("use the object(String name) form");
    }

    @Override
    public DslPart closeObject() {
        this.parent.putObject(this);
        return this.parent;
    }

    @Override
    public PactDslJsonArray array(String name) {
        return new PactDslJsonArray(this.root + "." + name, this);
    }

    @Override
    public PactDslJsonArray array() {
        throw new UnsupportedOperationException("use the array(String name) form");
    }

    @Override
    public DslPart closeArray() {
        throw new UnsupportedOperationException("can't call closeArray on an Object");
    }

    public PactDslJsonBody id() {
        return this.id("id");
    }

    public PactDslJsonBody id(String name) {
        this.body.put(name, Long.parseLong(RandomStringUtils.randomNumeric((int)10)));
        this.matchers.put(this.root + "." + name, this.matchType());
        return this;
    }

    public PactDslJsonBody hexValue(String name) {
        this.body.put(name, (Object)RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
        this.matchers.put(this.root + "." + name, this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    public PactDslJsonBody guid(String name) {
        this.body.put(name, (Object)UUID.randomUUID().toString());
        this.matchers.put(this.root + "." + name, this.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return this;
    }
}

