/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.DslPart;
import au.com.dius.pact.consumer.PactDslJsonBody;
import java.util.Date;
import java.util.UUID;
import nl.flotsam.xeger.Xeger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONArray;

public class PactDslJsonArray
extends DslPart {
    private final JSONArray body = new JSONArray();

    public PactDslJsonArray(String root, DslPart parent) {
        super(parent, root);
    }

    @Override
    public DslPart closeArray() {
        this.parent.putArray(this);
        return this.parent;
    }

    @Override
    protected void putObject(DslPart object) {
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(matcherName, object.matchers.get(matcherName));
        }
        this.body.put(object.getBody());
    }

    @Override
    protected void putArray(DslPart object) {
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(matcherName, object.matchers.get(matcherName));
        }
        this.body.put(object.getBody());
    }

    @Override
    protected Object getBody() {
        return this.body;
    }

    public PactDslJsonArray stringValue(String value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray string(String value) {
        return this.stringValue(value);
    }

    public PactDslJsonArray numberValue(Number value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray number(Number value) {
        return this.numberValue(value);
    }

    public PactDslJsonArray booleanValue(Boolean value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray stringType() {
        this.body.put((Object)RandomStringUtils.randomAlphabetic((int)20));
        this.matchers.put(this.root + "." + this.body.length(), this.matchType());
        return this;
    }

    public PactDslJsonArray numberType() {
        this.body.put((Object)RandomStringUtils.randomNumeric((int)10));
        this.matchers.put(this.root + "." + this.body.length(), this.matchType());
        return this;
    }

    public PactDslJsonArray booleanType(String name) {
        this.body.put(true);
        this.matchers.put(this.root + "." + this.body.length(), this.matchType());
        return this;
    }

    public PactDslJsonArray stringMatcher(String regex, String value) {
        this.body.put((Object)value);
        this.matchers.put(this.root + "." + this.body.length(), this.regexp(regex));
        return this;
    }

    public PactDslJsonArray stringMatcher(String regex) {
        this.stringMatcher(regex, new Xeger(regex).generate());
        return this;
    }

    public PactDslJsonArray timestamp() {
        this.body.put((Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date()));
        this.matchers.put(this.root + "." + this.body.length(), this.matchTimestamp(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray timestamp(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.root + "." + this.body.length(), this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonArray date() {
        this.body.put((Object)DateFormatUtils.ISO_DATE_FORMAT.format(new Date()));
        this.matchers.put(this.root + "." + this.body.length(), this.matchDate(DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray date(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.root + "." + this.body.length(), this.matchDate(format));
        return this;
    }

    public PactDslJsonArray time() {
        this.body.put((Object)DateFormatUtils.ISO_TIME_FORMAT.format(new Date()));
        this.matchers.put(this.root + "." + this.body.length(), this.matchTime(DateFormatUtils.ISO_TIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray time(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.root + "." + this.body.length(), this.matchTime(format));
        return this;
    }

    public PactDslJsonArray ipAddress() {
        this.body.put((Object)"127.0.0.1");
        this.matchers.put(this.root + "." + this.body.length(), this.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return this;
    }

    @Override
    public PactDslJsonBody object(String name) {
        throw new UnsupportedOperationException("use the object() form");
    }

    @Override
    public PactDslJsonBody object() {
        return new PactDslJsonBody(this.root + "." + (this.body.length() + 1), this);
    }

    @Override
    public DslPart closeObject() {
        throw new UnsupportedOperationException("can't call closeObject on an Array");
    }

    @Override
    public PactDslJsonArray array(String name) {
        throw new UnsupportedOperationException("use the array() form");
    }

    @Override
    public PactDslJsonArray array() {
        return new PactDslJsonArray(this.root + "." + (this.body.length() + 1), this);
    }

    public PactDslJsonArray id() {
        this.body.put((Object)RandomStringUtils.randomNumeric((int)10));
        this.matchers.put(this.root + "." + this.body.length(), this.matchType());
        return this;
    }

    public PactDslJsonArray hexValue() {
        this.body.put((Object)RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
        this.matchers.put(this.root + "." + this.body.length(), this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    public PactDslJsonArray guid(String name) {
        this.body.put((Object)UUID.randomUUID().toString());
        this.matchers.put(this.root + "." + name, this.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return this;
    }
}

