/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.MessagePactBuilder;
import au.com.dius.pact.consumer.Pact;
import au.com.dius.pact.consumer.PactConsumerConfig$;
import au.com.dius.pact.consumer.PactVerification;
import au.com.dius.pact.consumer.PactVerified$;
import au.com.dius.pact.consumer.VerificationResult;
import au.com.dius.pact.model.v3.messaging.Message;
import au.com.dius.pact.model.v3.messaging.MessagePact;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class MessagePactProviderRule
extends ExternalResource {
    private Map<String, Message> providerStateMessages;
    private Object testClassInstance;
    public static VerificationResult PACT_VERIFIED = PactVerified$.MODULE$;
    private MessagePact messagePact;

    public MessagePactProviderRule(Object testClassInstance) {
        this.testClassInstance = testClassInstance;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                Message providedMessage = null;
                Map pacts = MessagePactProviderRule.this.parsePacts();
                if (pactDef.value().length == 2 && !pactDef.value()[1].trim().isEmpty()) {
                    providedMessage = (Message)pacts.get(pactDef.value()[1].trim());
                } else if (!pacts.isEmpty()) {
                    providedMessage = (Message)pacts.values().iterator().next();
                }
                if (providedMessage == null) {
                    base.evaluate();
                    return;
                }
                Method messageSetter = null;
                try {
                    messageSetter = description.getTestClass().getMethod("setMessage", byte[].class);
                }
                catch (Exception e) {
                    base.evaluate();
                    return;
                }
                if (messageSetter != null) {
                    messageSetter.invoke(MessagePactProviderRule.this.testClassInstance, new Object[]{providedMessage.contentsAsBytes()});
                }
                base.evaluate();
                MessagePactProviderRule.this.messagePact.write(PactConsumerConfig$.MODULE$.pactRootDir());
            }
        };
    }

    private Map<String, Message> parsePacts() {
        if (this.providerStateMessages == null) {
            this.providerStateMessages = new HashMap<String, Message>();
            for (Method m : this.testClassInstance.getClass().getMethods()) {
                String provider;
                Pact pact;
                if (!this.conformsToSignature(m) || (pact = m.getAnnotation(Pact.class)) == null || (provider = pact.provider()) == null || provider.trim().isEmpty()) continue;
                MessagePactBuilder builder = MessagePactBuilder.consumer(pact.consumer()).hasPactWith(provider);
                List messages = null;
                try {
                    this.messagePact = (MessagePact)m.invoke(this.testClassInstance, builder);
                    messages = this.messagePact.getMessages();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke pact method", e);
                }
                for (Message message : messages) {
                    this.providerStateMessages.put(message.getProviderState(), message);
                }
            }
        }
        return this.providerStateMessages;
    }

    private boolean conformsToSignature(Method m) {
        boolean conforms;
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = conforms = pact != null && MessagePact.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(MessagePactBuilder.class);
        if (!conforms && pact != null) {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public PactFragment xxx(PactDslWithProvider builder)'");
        }
        return conforms;
    }
}

