/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.Pact;
import au.com.dius.pact.consumer.PactError;
import au.com.dius.pact.consumer.PactMismatch;
import au.com.dius.pact.consumer.PactMismatchException;
import au.com.dius.pact.consumer.PactVerification;
import au.com.dius.pact.consumer.PactVerified$;
import au.com.dius.pact.consumer.TestRun;
import au.com.dius.pact.consumer.UserCodeFailed;
import au.com.dius.pact.consumer.VerificationResult;
import au.com.dius.pact.model.MockProviderConfig;
import au.com.dius.pact.model.PactFragment;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactProviderRule
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactProviderRule.class);
    public static VerificationResult PACT_VERIFIED = PactVerified$.MODULE$;
    private Map<String, PactFragment> fragments;
    private final String provider;
    private Object target;
    private final MockProviderConfig config;

    public PactProviderRule(String provider, String host, Integer port, Object target) {
        this.provider = provider;
        this.target = target;
        this.config = host == null && port == null ? MockProviderConfig.createDefault() : new MockProviderConfig(port.intValue(), host);
    }

    public PactProviderRule(String provider, Object target) {
        this(provider, null, null, target);
    }

    public MockProviderConfig getConfig() {
        return this.config;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                PactFragment fragment = PactProviderRule.this.getPacts().get(pactDef.value());
                if (fragment == null) {
                    base.evaluate();
                    return;
                }
                VerificationResult result = fragment.runConsumer(PactProviderRule.this.config, new TestRun(){

                    public void run(MockProviderConfig config) throws Throwable {
                        base.evaluate();
                    }
                });
                if (!result.equals(PACT_VERIFIED)) {
                    if (result instanceof PactError) {
                        throw ((PactError)result).error();
                    }
                    if (result instanceof UserCodeFailed) {
                        throw (RuntimeException)((UserCodeFailed)result).error();
                    }
                    if (result instanceof PactMismatch && !pactDef.expectMismatch()) {
                        PactMismatch mismatch = (PactMismatch)result;
                        throw new PactMismatchException(mismatch);
                    }
                } else if (pactDef.expectMismatch()) {
                    throw new RuntimeException("Expected a pact mismatch (PactVerification.expectMismatch is set to true)");
                }
            }
        };
    }

    protected Map<String, PactFragment> getPacts() {
        if (this.fragments == null) {
            this.fragments = new HashMap<String, PactFragment>();
            for (Method m : this.target.getClass().getMethods()) {
                Pact pact;
                if (!this.conformsToSigniture(m) || !this.provider.equals((pact = m.getAnnotation(Pact.class)).provider())) continue;
                ConsumerPactBuilder.PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)pact.consumer()).hasPactWith(pact.provider());
                try {
                    this.fragments.put(pact.provider(), (PactFragment)m.invoke(this.target, dslBuilder));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to invoke pact method", (Throwable)e);
                    throw new RuntimeException("Failed to invoke pact method", e);
                }
            }
        }
        return this.fragments;
    }

    private boolean conformsToSigniture(Method m) {
        boolean conforms;
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = conforms = pact != null && PactFragment.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(ConsumerPactBuilder.PactDslWithProvider.class);
        if (!conforms && pact != null) {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public PactFragment xxx(PactDslWithProvider builder)'");
        }
        return conforms;
    }
}

