/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.json.JSONObject;

public class PactDslJsonBody {
    private JSONObject body;
    private Map<String, Object> matchers = new HashMap<String, Object>();
    private String root = "$.body";
    private PactDslJsonBody parent;

    public PactDslJsonBody() {
        this.body = new JSONObject();
    }

    public PactDslJsonBody(String root, PactDslJsonBody parent) {
        this();
        this.root = root;
        this.parent = parent;
    }

    public String toString() {
        return this.body.toString();
    }

    public PactDslJsonBody stringValue(String name, String value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody stringValue(String name) {
        this.body.put(name, (Object)RandomStringUtils.randomAlphabetic((int)20));
        this.matchers.put(this.root + "." + name, this.matchType());
        return this;
    }

    public PactDslJsonBody numberValue(String name, Number value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody booleanValue(String name, Boolean value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody stringMatcher(String name, String value) {
        this.body.put(name, (Object)value);
        this.matchers.put(this.root + "." + name, this.regexp(value));
        return this;
    }

    public PactDslJsonBody timestamp() {
        return this.timestamp("timestamp");
    }

    public PactDslJsonBody timestamp(String name) {
        this.body.put(name, (Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date()));
        this.matchers.put(this.root + "." + name, this.matchTimestamp());
        return this;
    }

    public PactDslJsonBody ipAddress(String name) {
        this.body.put(name, (Object)"127.0.0.1");
        this.matchers.put(this.root + "." + name, this.regexp("(\\d{1-3}\\.)+\\d{1-3}"));
        return this;
    }

    public PactDslJsonBody object(String name) {
        return new PactDslJsonBody(this.root + "." + name, this);
    }

    public PactDslJsonBody closeObject() {
        this.parent.putObject(this);
        return this.parent;
    }

    public PactDslJsonBody id() {
        return this.id("id");
    }

    public PactDslJsonBody id(String name) {
        this.body.put(name, (Object)RandomStringUtils.randomNumeric((int)10));
        this.matchers.put(this.root + "." + name, this.regexp("\\d+"));
        return this;
    }

    public PactDslJsonBody hexValue(String name) {
        this.body.put(name, (Object)RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
        this.matchers.put(this.root + "." + name, this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    private void putObject(PactDslJsonBody object) {
        String name = StringUtils.difference((String)(this.root + "."), (String)object.root);
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(matcherName, object.matchers.get(matcherName));
        }
        this.body.put(name, (Object)object.body);
    }

    private Map<String, Object> matchType() {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("match", "type");
        return jsonObject;
    }

    private Map<String, Object> regexp(String value) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("regex", value);
        return jsonObject;
    }

    private Map<String, Object> matchTimestamp() {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("match", "timestamp");
        return jsonObject;
    }

    public Map<String, Object> getMatchers() {
        return this.matchers;
    }

    public void setMatchers(Map<String, Object> matchers) {
        this.matchers = matchers;
    }
}

