/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import java.util.Date;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.json.JSONObject;

public class PactDslJsonBody {
    private JSONObject body;
    private JSONObject matchers = new JSONObject();
    private String root = "$.body";
    private PactDslJsonBody parent;

    public PactDslJsonBody() {
        this.body = new JSONObject();
    }

    public PactDslJsonBody(String root, PactDslJsonBody parent) {
        this();
        this.root = root;
        this.parent = parent;
    }

    public String toString() {
        return this.body.toString();
    }

    public PactDslJsonBody stringValue(String name, String value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody stringValue(String name) {
        this.body.put(name, (Object)RandomStringUtils.randomAlphabetic((int)20));
        this.matchers.put(this.root + "." + name, (Object)this.matchType());
        return this;
    }

    public PactDslJsonBody numberValue(String name, Number value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody booleanValue(String name, Boolean value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody stringMatcher(String name, String value) {
        this.body.put(name, (Object)value);
        this.matchers.put(this.root + "." + name, (Object)this.regexp(value));
        return this;
    }

    public PactDslJsonBody timestamp() {
        return this.timestamp("timestamp");
    }

    public PactDslJsonBody timestamp(String name) {
        this.body.put(name, (Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date()));
        this.matchers.put(this.root + "." + name, (Object)this.matchTimestamp());
        return this;
    }

    public PactDslJsonBody ipAddress(String name) {
        this.body.put(name, (Object)"127.0.0.1");
        this.matchers.put(this.root + "." + name, (Object)this.regexp("(\\d{1-3}\\.)+\\d{1-3}"));
        return this;
    }

    public PactDslJsonBody object(String name) {
        return new PactDslJsonBody(this.root + "." + name, this);
    }

    public PactDslJsonBody closeObject() {
        this.parent.putObject(this);
        return this.parent;
    }

    public PactDslJsonBody id() {
        return this.id("id");
    }

    public PactDslJsonBody id(String name) {
        this.body.put(name, (Object)RandomStringUtils.randomNumeric((int)10));
        this.matchers.put(this.root + "." + name, (Object)this.regexp("\\d+"));
        return this;
    }

    public PactDslJsonBody hexValue(String name) {
        this.body.put(name, (Object)RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
        this.matchers.put(this.root + "." + name, (Object)this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    private void putObject(PactDslJsonBody object) {
        String name = StringUtils.difference((String)(this.root + "."), (String)object.root);
        for (String matcherName : JSONObject.getNames((JSONObject)object.matchers)) {
            this.matchers.put(matcherName, object.matchers.get(matcherName));
        }
        this.body.put(name, (Object)object.body);
    }

    private JSONObject matchType() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("match", (Object)"type");
        return jsonObject;
    }

    private JSONObject regexp(String value) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("regex", (Object)value);
        return jsonObject;
    }

    private JSONObject matchTimestamp() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("match", (Object)"timestamp");
        return jsonObject;
    }

    public JSONObject getMatchers() {
        return this.matchers;
    }

    public void setMatchers(JSONObject matchers) {
        this.matchers = matchers;
    }
}

