/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.Interaction$;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.Provider;
import au.com.dius.pact.model.Request$;
import au.com.dius.pact.model.Response$;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public class ConsumerPactBuilder {
    private String consumerName;

    public ConsumerPactBuilder(String string) {
        this.consumerName = string;
    }

    public static ConsumerPactBuilder consumer(String string) {
        return new ConsumerPactBuilder(string);
    }

    public PactDslWithProvider hasPactWith(String string) {
        return new PactDslWithProvider(string);
    }

    public class PactDslResponse {
        private PactDslRequestWithPath existing;
        private int responseStatus;
        private Map<String, String> responseHeaders;
        private String responseBody;

        public PactDslResponse(PactDslRequestWithPath pactDslRequestWithPath) {
            this.existing = pactDslRequestWithPath;
        }

        public PactDslResponse status(int n) {
            this.responseStatus = n;
            return this;
        }

        public PactDslResponse headers(Map<String, String> map) {
            this.responseHeaders = map;
            return this;
        }

        public PactDslResponse body(String string) {
            this.responseBody = string;
            return this;
        }

        private void addInteraction() {
            Interaction interaction = Interaction$.MODULE$.apply(this.existing.description, this.existing.state, Request$.MODULE$.apply(this.existing.requestMethod, this.existing.path, this.existing.requestHeaders, this.existing.requestBody), Response$.MODULE$.apply(this.responseStatus, this.responseHeaders, this.responseBody));
            this.existing.interactions.add(interaction);
        }

        public PactFragment toFragment() {
            this.addInteraction();
            return new PactFragment(this.existing.consumer, this.existing.provider, (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.existing.interactions).asScala());
        }

        public PactDslRequestWithPath uponReceiving(String string) {
            this.addInteraction();
            return new PactDslRequestWithPath(this.existing, string);
        }
    }

    public class PactDslRequestWithPath {
        private Consumer consumer;
        private Provider provider;
        private String state;
        private String description;
        private String path;
        private String requestMethod;
        private Map<String, String> requestHeaders;
        private String requestBody;
        private List<Interaction> interactions = new ArrayList<Interaction>();

        public PactDslRequestWithPath(String string, String string2, String string3, String string4, String string5, String string6, Map<String, String> map, String string7) {
            this.consumer = new Consumer(string);
            this.provider = new Provider(string2);
            this.state = string3;
            this.description = string4;
            this.path = string5;
            this.requestMethod = string6;
            this.requestHeaders = map;
            this.requestBody = string7;
        }

        public PactDslRequestWithPath(PactDslRequestWithPath pactDslRequestWithPath, String string) {
            this.consumer = pactDslRequestWithPath.consumer;
            this.provider = pactDslRequestWithPath.provider;
            this.state = pactDslRequestWithPath.state;
            this.description = string;
            this.path = pactDslRequestWithPath.path;
            this.requestMethod = pactDslRequestWithPath.requestMethod;
            this.requestHeaders = pactDslRequestWithPath.requestHeaders;
            this.requestBody = pactDslRequestWithPath.requestBody;
            this.interactions = pactDslRequestWithPath.interactions;
        }

        public PactDslRequestWithPath method(String string) {
            this.requestMethod = string;
            return this;
        }

        public PactDslRequestWithPath headers(Map<String, String> map) {
            this.requestHeaders = map;
            return this;
        }

        public PactDslRequestWithPath body(String string) {
            this.requestBody = string;
            return this;
        }

        public PactDslRequestWithPath path(String string) {
            this.path = string;
            return this;
        }

        public PactDslResponse willRespondWith() {
            return new PactDslResponse(this);
        }
    }

    public class PactDslWithProvider {
        private String providerName;

        public PactDslWithProvider(String string) {
            this.providerName = string;
        }

        public PactDslWithState given(String string) {
            return new PactDslWithState(string);
        }

        public class PactDslWithState {
            private String state;

            public PactDslWithState(String string) {
                this.state = string;
            }

            public PactDslRequestWithoutPath uponReceiving(String string) {
                return new PactDslRequestWithoutPath(string);
            }

            public class PactDslRequestWithoutPath {
                private String description;
                private String requestMethod;
                private Map<String, String> requestHeaders;
                private String requestBody;

                public PactDslRequestWithoutPath(String string) {
                    this.description = string;
                }

                public PactDslRequestWithoutPath method(String string) {
                    this.requestMethod = string;
                    return this;
                }

                public PactDslRequestWithoutPath headers(Map<String, String> map) {
                    this.requestHeaders = map;
                    return this;
                }

                public PactDslRequestWithoutPath body(String string) {
                    this.requestBody = string;
                    return this;
                }

                public PactDslRequestWithPath path(String string) {
                    return new PactDslRequestWithPath(ConsumerPactBuilder.this.consumerName, PactDslWithProvider.this.providerName, PactDslWithState.this.state, this.description, string, this.requestMethod, this.requestHeaders, this.requestBody);
                }
            }
        }
    }
}

