/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.junit;

import au.com.dius.pact.consumer.MessagePactBuilder;
import au.com.dius.pact.consumer.PactConsumerConfig;
import au.com.dius.pact.consumer.junit.JUnitTestSupport;
import au.com.dius.pact.consumer.junit.PactVerification;
import au.com.dius.pact.consumer.junit.PactVerifications;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.annotations.Pact;
import au.com.dius.pact.core.model.annotations.PactFolder;
import au.com.dius.pact.core.model.messaging.Message;
import au.com.dius.pact.core.model.messaging.MessagePact;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class MessagePactProviderRule
extends ExternalResource {
    private final String provider;
    private final Object testClassInstance;
    private byte[] message;
    private Map<String, Message> providerStateMessages;
    private MessagePact messagePact;
    private Map<String, String> metadata;

    public MessagePactProviderRule(Object testClassInstance) {
        this(null, testClassInstance);
    }

    public MessagePactProviderRule(String provider, Object testClassInstance) {
        this.provider = provider;
        this.testClassInstance = testClassInstance;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                HashMap<String, Message> pacts;
                PactVerifications pactVerifications = (PactVerifications)description.getAnnotation(PactVerifications.class);
                if (pactVerifications != null) {
                    MessagePactProviderRule.this.evaluatePactVerifications(pactVerifications, base, description);
                    return;
                }
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                Message providedMessage = null;
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{pactDef.fragment()})) {
                    Optional possiblePactMethod = MessagePactProviderRule.this.findPactMethod(pactDef);
                    if (!possiblePactMethod.isPresent()) {
                        base.evaluate();
                        return;
                    }
                    pacts = new HashMap<String, Message>();
                    Method method = (Method)possiblePactMethod.get();
                    Pact pact = method.getAnnotation(Pact.class);
                    MessagePactBuilder builder = MessagePactBuilder.consumer((String)pact.consumer()).hasPactWith(MessagePactProviderRule.this.provider);
                    MessagePactProviderRule.this.messagePact = (MessagePact)method.invoke(MessagePactProviderRule.this.testClassInstance, builder);
                    for (Message message : MessagePactProviderRule.this.messagePact.getMessages()) {
                        pacts.put(message.getProviderStates().stream().map(ProviderState::getName).collect(Collectors.joining()), message);
                    }
                } else {
                    pacts = MessagePactProviderRule.this.parsePacts();
                }
                if (pactDef.value().length == 2 && !pactDef.value()[1].trim().isEmpty()) {
                    providedMessage = (Message)pacts.get(pactDef.value()[1].trim());
                } else if (!pacts.isEmpty()) {
                    providedMessage = (Message)pacts.values().iterator().next();
                }
                if (providedMessage == null) {
                    base.evaluate();
                    return;
                }
                MessagePactProviderRule.this.setMessage(providedMessage, description);
                base.evaluate();
                PactFolder pactFolder = MessagePactProviderRule.this.testClassInstance.getClass().getAnnotation(PactFolder.class);
                if (pactFolder != null) {
                    MessagePactProviderRule.this.messagePact.write(pactFolder.value(), PactSpecVersion.V3);
                } else {
                    MessagePactProviderRule.this.messagePact.write(PactConsumerConfig.INSTANCE.getPactDirectory(), PactSpecVersion.V3);
                }
            }
        };
    }

    private void evaluatePactVerifications(PactVerifications pactVerifications, Statement base, Description description) throws Throwable {
        if (this.provider == null) {
            throw new UnsupportedOperationException("This provider name cannot be null when using @PactVerifications");
        }
        Optional<PactVerification> possiblePactVerification = this.findPactVerification(pactVerifications);
        if (!possiblePactVerification.isPresent()) {
            base.evaluate();
            return;
        }
        PactVerification pactVerification = possiblePactVerification.get();
        Optional<Method> possiblePactMethod = this.findPactMethod(pactVerification);
        if (!possiblePactMethod.isPresent()) {
            throw new UnsupportedOperationException("Could not find method with @Pact for the provider " + this.provider);
        }
        Method method = possiblePactMethod.get();
        Pact pact = method.getAnnotation(Pact.class);
        MessagePactBuilder builder = MessagePactBuilder.consumer((String)pact.consumer()).hasPactWith(this.provider);
        MessagePact messagePact = (MessagePact)method.invoke(this.testClassInstance, builder);
        this.setMessage((Message)messagePact.getMessages().get(0), description);
        base.evaluate();
        messagePact.write(PactConsumerConfig.INSTANCE.getPactDirectory(), PactSpecVersion.V3);
    }

    private Optional<PactVerification> findPactVerification(PactVerifications pactVerifications) {
        PactVerification[] pactVerificationValues = pactVerifications.value();
        return Arrays.stream(pactVerificationValues).filter(p -> {
            String[] providers = p.value();
            if (providers.length != 1) {
                throw new IllegalArgumentException("Each @PactVerification must specify one and only provider when using @PactVerifications");
            }
            String provider = providers[0];
            return provider.equals(this.provider);
        }).findFirst();
    }

    private Optional<Method> findPactMethod(PactVerification pactVerification) {
        String pactFragment = pactVerification.fragment();
        for (Method method : this.testClassInstance.getClass().getMethods()) {
            Pact pact = method.getAnnotation(Pact.class);
            if (pact == null || !pact.provider().equals(this.provider) || !pactFragment.isEmpty() && !pactFragment.equals(method.getName())) continue;
            JUnitTestSupport.conformsToMessagePactSignature((Method)method);
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private Map<String, Message> parsePacts() {
        if (this.providerStateMessages == null) {
            this.providerStateMessages = new HashMap<String, Message>();
            for (Method m : this.testClassInstance.getClass().getMethods()) {
                String provider;
                Pact pact;
                if (!this.conformsToSignature(m) || (pact = m.getAnnotation(Pact.class)) == null || (provider = pact.provider()) == null || provider.trim().isEmpty()) continue;
                MessagePactBuilder builder = MessagePactBuilder.consumer((String)pact.consumer()).hasPactWith(provider);
                List messages = null;
                try {
                    this.messagePact = (MessagePact)m.invoke(this.testClassInstance, builder);
                    messages = this.messagePact.getMessages();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke pact method", e);
                }
                for (Message message : messages) {
                    if (message.getProviderStates().isEmpty()) {
                        this.providerStateMessages.put("", message);
                        continue;
                    }
                    for (ProviderState state : message.getProviderStates()) {
                        this.providerStateMessages.put(state.getName(), message);
                    }
                }
            }
        }
        return this.providerStateMessages;
    }

    private boolean conformsToSignature(Method m) {
        boolean conforms;
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = conforms = pact != null && MessagePact.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(MessagePactBuilder.class);
        if (!conforms && pact != null) {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public MessagePact xxx(MessagePactBuilder builder)'");
        }
        return conforms;
    }

    public byte[] getMessage() {
        if (this.message == null) {
            throw new UnsupportedOperationException("Message was not created and cannot be retrieved. Check @Pact and @PactVerification match.");
        }
        return this.message;
    }

    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            throw new UnsupportedOperationException("Message metadata was not created and cannot be retrieved. Check @Pact and @PactVerification match.");
        }
        return this.metadata;
    }

    private void setMessage(Message message, Description description) throws InvocationTargetException, IllegalAccessException {
        Method messageSetter;
        this.message = message.contentsAsBytes();
        this.metadata = message.getMetaData();
        try {
            messageSetter = description.getTestClass().getMethod("setMessage", byte[].class);
        }
        catch (Exception e) {
            return;
        }
        messageSetter.invoke(this.testClassInstance, new Object[]{message.contentsAsBytes()});
    }
}

