/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.groovy;

import au.com.dius.pact.consumer.groovy.AndMatcher;
import au.com.dius.pact.consumer.groovy.DateMatcher;
import au.com.dius.pact.consumer.groovy.EachLikeMatcher;
import au.com.dius.pact.consumer.groovy.EqualsMatcher;
import au.com.dius.pact.consumer.groovy.HexadecimalMatcher;
import au.com.dius.pact.consumer.groovy.IncludeMatcher;
import au.com.dius.pact.consumer.groovy.InvalidMatcherException;
import au.com.dius.pact.consumer.groovy.Matcher;
import au.com.dius.pact.consumer.groovy.MaxLikeMatcher;
import au.com.dius.pact.consumer.groovy.MinLikeMatcher;
import au.com.dius.pact.consumer.groovy.MinMaxLikeMatcher;
import au.com.dius.pact.consumer.groovy.NullMatcher;
import au.com.dius.pact.consumer.groovy.OrMatcher;
import au.com.dius.pact.consumer.groovy.RegexpMatcher;
import au.com.dius.pact.consumer.groovy.TimeMatcher;
import au.com.dius.pact.consumer.groovy.TimestampMatcher;
import au.com.dius.pact.consumer.groovy.TypeMatcher;
import au.com.dius.pact.consumer.groovy.UrlMatcher;
import au.com.dius.pact.consumer.groovy.UuidMatcher;
import au.com.dius.pact.model.generators.RandomBooleanGenerator;
import au.com.dius.pact.model.generators.RandomDecimalGenerator;
import au.com.dius.pact.model.generators.RandomIntGenerator;
import au.com.dius.pact.model.generators.RandomStringGenerator;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;

public class Matchers
implements GroovyObject {
    private static final String HEXADECIMAL = "[0-9a-fA-F]+";
    private static final String IP_ADDRESS = "(\\d{1,3}\\.)+\\d{1,3}";
    private static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    private static final int TEN = 10;
    private static final String TYPE = "type";
    private static final String DECIMAL = "decimal";
    private static final long DATE_2000 = 949323600000L;
    private static final String INTEGER = "integer";
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ BigDecimal $const$1;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public Matchers() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Object regexp(Pattern re, String value) {
        return IndyInterface.bootstrap("invoke", "regexp", 0, Matchers.class, IndyInterface.bootstrap("invoke", "toString", 0, re), value);
    }

    public static Object regexp(String regexp, String value) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, value, regexp)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value, regexp}, new String[]{"Example \"", "\" does not match regular expression \"", "\""})));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, RegexpMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"regex", regexp, "value", value}));
    }

    public static Object hexValue(String value) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, value, HEXADECIMAL)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value}, new String[]{"Example \"", "\" is not a hexadecimal value"})));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, HexadecimalMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", value}));
    }

    public static Object identifier(Object value) {
        Object object = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", IndyInterface.bootstrap("cast", "()", 0, object) != false ? object : Integer.valueOf(12345678), TYPE, INTEGER, "generator", ScriptBytecodeAdapter.compareEqual((Object)value, null) ? IndyInterface.bootstrap("init", "<init>", 0, RandomIntGenerator.class, false, IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class)) : null}));
    }

    public static Object ipAddress(String value) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, value, IP_ADDRESS)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value}, new String[]{"Example \"", "\" is not an ip adress"})));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, RegexpMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", "127.0.0.1", "regex", IP_ADDRESS}));
    }

    public static Object numeric(Number value) {
        Number number = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{TYPE, "number", "value", IndyInterface.bootstrap("cast", "()", 0, number) != false ? (Number)number : (Number)100, "generator", ScriptBytecodeAdapter.compareEqual((Object)value, null) ? IndyInterface.bootstrap("init", "<init>", 0, RandomDecimalGenerator.class, 6) : null}));
    }

    @Deprecated
    public static Object real(Number value) {
        return IndyInterface.bootstrap("invoke", DECIMAL, 0, Matchers.class, value);
    }

    public static Object decimal(Number value) {
        Number number = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{TYPE, DECIMAL, "value", IndyInterface.bootstrap("cast", "()", 0, number) != false ? number : $const$1, "generator", ScriptBytecodeAdapter.compareEqual((Object)value, null) ? IndyInterface.bootstrap("init", "<init>", 0, RandomDecimalGenerator.class, 6) : null}));
    }

    public static Object integer(Long value) {
        Long l = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{TYPE, INTEGER, "value", IndyInterface.bootstrap("cast", "()", 0, l) != false ? l : IndyInterface.bootstrap("cast", "()", 0, 100), "generator", ScriptBytecodeAdapter.compareEqual((Object)value, null) ? IndyInterface.bootstrap("init", "<init>", 0, RandomIntGenerator.class, false, IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class)) : null}));
    }

    public static Object timestamp(String pattern, Object value) {
        IndyInterface.bootstrap("invoke", "validateTimeValue", 0, Matchers.class, value, pattern);
        return IndyInterface.bootstrap("init", "<init>", 0, TimestampMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", value, "pattern", pattern}));
    }

    public static Object timestampExpression(String expression, String pattern) {
        return IndyInterface.bootstrap("init", "<init>", 0, TimestampMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pattern", pattern, "expression", expression}));
    }

    private static Object validateTimeValue(String value, String pattern) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && DefaultTypeTransformation.booleanUnbox((Object)pattern)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "parseDateStrictly", 0, DateUtils.class, value, pattern);
            try {
                return callSite;
            }
            catch (ParseException e) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value, pattern}, new String[]{"Example \"", "\" does not match pattern \"", "\""})));
            }
        }
        return null;
    }

    public static Object time(String pattern, Object value) {
        IndyInterface.bootstrap("invoke", "validateTimeValue", 0, Matchers.class, value, pattern);
        return IndyInterface.bootstrap("init", "<init>", 0, TimeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", value, "pattern", pattern}));
    }

    public static Object timeExpression(String expression, String pattern) {
        return IndyInterface.bootstrap("init", "<init>", 0, TimeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pattern", pattern, "expression", expression}));
    }

    public static Object date(String pattern, Object value) {
        IndyInterface.bootstrap("invoke", "validateTimeValue", 0, Matchers.class, value, pattern);
        return IndyInterface.bootstrap("init", "<init>", 0, DateMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", value, "pattern", pattern}));
    }

    public static Object dateExpression(String expression, String pattern) {
        return IndyInterface.bootstrap("init", "<init>", 0, DateMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pattern", pattern, "expression", expression}));
    }

    @Deprecated
    public static Object guid(String value) {
        return IndyInterface.bootstrap("invoke", "uuid", 0, Matchers.class, value);
    }

    public static Object uuid(String value) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, value, UUID_REGEX)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value}, new String[]{"Example \"", "\" is not a UUID"})));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, UuidMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", value}));
    }

    public static Object string(String value) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)value, null)) {
            return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", value}));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", "string", "generator", IndyInterface.bootstrap("init", "<init>", 0, RandomStringGenerator.class, 10)}));
    }

    public static Object bool(Boolean value) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)value, null)) {
            return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", value}));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", true, "generator", IndyInterface.bootstrap("getProperty", "INSTANCE", 0, RandomBooleanGenerator.class)}));
    }

    public static Object eachLike(Integer numberExamples, Object arg) {
        return IndyInterface.bootstrap("init", "<init>", 0, EachLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", arg, "numberExamples", numberExamples}));
    }

    public static Object maxLike(Integer max, Integer numberExamples, Object arg) {
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)numberExamples, (Object)max)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{numberExamples}, new String[]{"The number of examples you have specified (", ") is "}), new GStringImpl(new Object[]{max}, new String[]{"greater than the maximum (", ")"}))));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, MaxLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"max", max, "value", arg, "numberExamples", numberExamples}));
    }

    public static Object minLike(Integer min, Integer numberExamples, Object arg) {
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)numberExamples, (Object)1) && ScriptBytecodeAdapter.compareLessThan((Object)numberExamples, (Object)min)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{numberExamples}, new String[]{"The number of examples you have specified (", ") is "}), new GStringImpl(new Object[]{min}, new String[]{"less than the minimum (", ")"}))));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, MinLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", min, "value", arg, "numberExamples", numberExamples}));
    }

    public static Object minMaxLike(Integer min, Integer max, Integer numberExamples, Object arg) {
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)min, (Object)max)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{min}, new String[]{"The minimum you have specified (", ") is "}), new GStringImpl(new Object[]{max}, new String[]{"greater than the maximum (", ")"}))));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)numberExamples, (Object)1) && ScriptBytecodeAdapter.compareLessThan((Object)numberExamples, (Object)min)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{numberExamples}, new String[]{"The number of examples you have specified (", ") is "}), new GStringImpl(new Object[]{min}, new String[]{"less than the minimum (", ")"}))));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)numberExamples, (Object)1) && ScriptBytecodeAdapter.compareGreaterThan((Object)numberExamples, (Object)max)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{numberExamples}, new String[]{"The number of examples you have specified (", ") is "}), new GStringImpl(new Object[]{max}, new String[]{"greater than the maximum (", ")"}))));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, MinMaxLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", min, "max", max, "value", arg, "numberExamples", numberExamples}));
    }

    public static Object equalTo(Object value) {
        return IndyInterface.bootstrap("init", "<init>", 0, EqualsMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", value}));
    }

    public static Object includesStr(Object value) {
        return IndyInterface.bootstrap("init", "<init>", 0, IncludeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", IndyInterface.bootstrap("invoke", "toString", 1, value)}));
    }

    public static Object or(Object example, Object ... values) {
        public final class _or_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _or_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                if (it instanceof Matcher) {
                    return it;
                }
                return IndyInterface.bootstrap("init", "<init>", 0, EqualsMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", it}));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _or_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("init", "<init>", 0, OrMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", example, "matchers", IndyInterface.bootstrap("invoke", "collect", 0, values, new _or_closure1(Matchers.class, Matchers.class))}));
    }

    public static Object and(Object example, Object ... values) {
        public final class _and_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _and_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                if (it instanceof Matcher) {
                    return it;
                }
                return IndyInterface.bootstrap("init", "<init>", 0, EqualsMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", it}));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _and_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("init", "<init>", 0, AndMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", example, "matchers", IndyInterface.bootstrap("invoke", "collect", 0, values, new _and_closure2(Matchers.class, Matchers.class))}));
    }

    public static Object nullValue() {
        return IndyInterface.bootstrap("init", "<init>", 0, NullMatcher.class);
    }

    public static Object url(String basePath, Object ... pathFragments) {
        return IndyInterface.bootstrap("init", "<init>", 0, UrlMatcher.class, basePath, ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, pathFragments, List.class))), List.class));
    }

    public static Object eachArrayLike(Integer numberExamples, Object arg) {
        return IndyInterface.bootstrap("init", "<init>", 0, EachLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", IndyInterface.bootstrap("init", "<init>", 0, EachLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"value", arg, "numberExamples", numberExamples})), "numberExamples", numberExamples}));
    }

    @Generated
    public static Object regexp(Pattern re) {
        return Matchers.regexp(re, null);
    }

    @Generated
    public static Object regexp(String regexp) {
        return Matchers.regexp(regexp, null);
    }

    @Generated
    public static Object hexValue() {
        return Matchers.hexValue(null);
    }

    @Generated
    public static Object identifier() {
        return Matchers.identifier(null);
    }

    @Generated
    public static Object ipAddress() {
        return Matchers.ipAddress(null);
    }

    @Generated
    public static Object numeric() {
        return Matchers.numeric(null);
    }

    @Deprecated
    @Generated
    public static Object real() {
        return Matchers.real(null);
    }

    @Generated
    public static Object decimal() {
        return Matchers.decimal(null);
    }

    @Generated
    public static Object integer() {
        return Matchers.integer(null);
    }

    @Generated
    public static Object timestamp(String pattern) {
        return Matchers.timestamp(pattern, null);
    }

    @Generated
    public static Object timestamp() {
        return Matchers.timestamp(null, null);
    }

    @Generated
    public static Object timestampExpression(String expression) {
        return Matchers.timestampExpression(expression, null);
    }

    @Generated
    public static Object time(String pattern) {
        return Matchers.time(pattern, null);
    }

    @Generated
    public static Object time() {
        return Matchers.time(null, null);
    }

    @Generated
    public static Object timeExpression(String expression) {
        return Matchers.timeExpression(expression, null);
    }

    @Generated
    public static Object date(String pattern) {
        return Matchers.date(pattern, null);
    }

    @Generated
    public static Object date() {
        return Matchers.date(null, null);
    }

    @Generated
    public static Object dateExpression(String expression) {
        return Matchers.dateExpression(expression, null);
    }

    @Deprecated
    @Generated
    public static Object guid() {
        return Matchers.guid(null);
    }

    @Generated
    public static Object uuid() {
        return Matchers.uuid(null);
    }

    @Generated
    public static Object string() {
        return Matchers.string(null);
    }

    @Generated
    public static Object bool() {
        return Matchers.bool(null);
    }

    @Generated
    public static Object eachLike(Object arg) {
        return Matchers.eachLike(1, arg);
    }

    @Generated
    public static Object maxLike(Integer max, Object arg) {
        return Matchers.maxLike(max, 1, arg);
    }

    @Generated
    public static Object minLike(Integer min, Object arg) {
        return Matchers.minLike(min, 1, arg);
    }

    @Generated
    public static Object minMaxLike(Integer min, Integer max, Object arg) {
        return Matchers.minMaxLike(min, max, 1, arg);
    }

    @Generated
    public static Object eachArrayLike(Object arg) {
        return Matchers.eachArrayLike(1, arg);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Matchers.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        long l;
        $const$0 = l = 949323600000L;
        $const$1 = bigDecimal = new BigDecimal("100.0");
    }

    static {
        Matchers.__$swapInit();
    }

    @Generated
    public static String getHEXADECIMAL() {
        return HEXADECIMAL;
    }

    @Generated
    public static String getIP_ADDRESS() {
        return IP_ADDRESS;
    }

    @Generated
    public static String getUUID_REGEX() {
        return UUID_REGEX;
    }

    @Generated
    public static int getTEN() {
        return TEN;
    }

    @Generated
    public static String getTYPE() {
        return TYPE;
    }

    @Generated
    public static String getDECIMAL() {
        return DECIMAL;
    }

    @Generated
    public static long getDATE_2000() {
        return DATE_2000;
    }

    @Generated
    public static String getINTEGER() {
        return INTEGER;
    }
}

