/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.fatboy.factory.semantic;

import au.com.dius.fatboy.factory.config.FactoryHint;
import au.com.dius.fatboy.factory.semantic.SemanticFieldFactory;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class SemanticFieldFactoryHint<T>
extends FactoryHint
implements SemanticFieldFactory<T> {
    private Map<Pattern, Supplier<T>> fieldPatterns = new HashMap<Pattern, Supplier<T>>();
    private Class<T> clazz;

    public SemanticFieldFactoryHint(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void addFieldMatcher(Pattern pattern, Supplier<T> supplier) {
        this.fieldPatterns.put(pattern, supplier);
    }

    @Override
    public boolean supports(Field field) {
        return field != null && this.clazz.isAssignableFrom(field.getType()) && this.findMatcher(field) != null;
    }

    @Override
    public T create(Field field) {
        Pattern matcher = this.findMatcher(field);
        return this.fieldPatterns.get(matcher).get();
    }

    private Pattern findMatcher(Field field) {
        return this.fieldPatterns.keySet().stream().filter(x -> x.matcher(field.getName()).matches()).findFirst().orElse(null);
    }
}

