/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.fatboy.factory.collections;

import au.com.dius.fatboy.ClassInstantiationException;
import au.com.dius.fatboy.FatBoy;
import au.com.dius.fatboy.factory.config.FactoryHint;
import au.com.dius.fatboy.factory.config.FieldLength;
import au.com.dius.fatboy.factory.impl.AbstractGenericClassFactory;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionFactory
extends AbstractGenericClassFactory<Collection> {
    private static final Map<Class, Class> classesMap = Collections.unmodifiableMap(new HashMap<Class, Class>(){
        {
            this.put(List.class, ArrayList.class);
            this.put(Set.class, HashSet.class);
        }
    });
    private FatBoy fatBoy;

    public CollectionFactory(FatBoy fatBoy) {
        super(Collection.class, (FactoryHint)FieldLength.constant(1L));
        this.fatBoy = fatBoy;
    }

    @Override
    public boolean supports(Class clazz, Type genericType) {
        return Collection.class.isAssignableFrom(clazz) && genericType instanceof ParameterizedType;
    }

    @Override
    public Collection create(Field field) {
        Type genericType = field.getGenericType();
        ParameterizedType impl = (ParameterizedType)genericType;
        return this.create(field.getType(), impl.getActualTypeArguments());
    }

    @Override
    public Collection create(Class rawType, Type[] actualParameters) {
        int count = this.getHint(FieldLength.class).getLength();
        try {
            Collection instance = (Collection)classesMap.get(rawType).newInstance();
            for (int x = 0; x < count; ++x) {
                instance.add(this.fatBoy.createGeneric(actualParameters[0]));
            }
            return instance;
        }
        catch (Exception e) {
            throw new ClassInstantiationException("Unable to create collection with generic type [" + rawType + "]", e);
        }
    }
}

