/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.fatboy;

import au.com.dius.fatboy.ClassInstantiationException;
import au.com.dius.fatboy.FactoryRepository;
import au.com.dius.fatboy.factory.ClassFactory;
import au.com.dius.fatboy.factory.GenericClassFactory;
import au.com.dius.fatboy.factory.GenericTypeFactory;
import au.com.dius.fatboy.factory.config.FactoryHint;
import au.com.dius.fatboy.utils.LambdaUtils;
import au.com.dius.fatboy.utils.ReflectionUtils;
import com.github.javafaker.Faker;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeResolver;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;

public class FatBoy {
    public static final Faker FAKER = new Faker();
    private final FactoryRepository factoryRepository = new FactoryRepository(this);

    public FatBoy() {
        this.factoryRepository.addIgnoredClass(SoftReference.class);
    }

    public <T> FatBoy registerClassFactory(ClassFactory<T> factory) {
        this.factoryRepository.addFactory(factory);
        return this;
    }

    public <T> FatBoy registerClassFactory(Class<T> clazz, Supplier<T> supplier) {
        this.factoryRepository.addFactory(clazz, supplier);
        return this;
    }

    public <T> FatBoy setClassConstant(T value) {
        this.factoryRepository.addFactory(value.getClass(), () -> value);
        return this;
    }

    public <T> FatBoy registerGenericFactory(Class<T> clazz, GenericTypeFactory<T> factory) {
        this.factoryRepository.addFactory(clazz, factory);
        return this;
    }

    public <T> FatBoy registerGenericFactory(Field field, GenericTypeFactory<T> factory) {
        this.factoryRepository.addFactory(field, factory);
        return this;
    }

    public <T> FatBoy setFieldConstant(Class clazz, String field, T value) {
        return this.setFieldConstant(ReflectionUtils.getField(clazz, field), value);
    }

    public <T> FatBoy setFieldConstant(Field field, T value) {
        return this.registerFieldFactory(field, () -> value);
    }

    public <T> FatBoy registerFieldFactory(Class clazz, String field, Supplier<T> factory) {
        return this.registerFieldFactory(ReflectionUtils.getField(clazz, field), factory);
    }

    public <T> FatBoy registerFieldFactory(Field field, Supplier<T> factory) {
        this.factoryRepository.addFactory(field, factory);
        return this;
    }

    public <T> FatBoy registerFatBoyProvidedFactory(Class<T> clazz, FatBoyProvidedFactory<T> factory) {
        this.factoryRepository.addFactory(clazz, () -> factory.create(this));
        return this;
    }

    public <T extends ClassFactory> ClassFactory findFactory(Class<T> factoryClass) {
        return this.factoryRepository.findFactory(factoryClass);
    }

    public FatBoy addIgnoredClass(Class clazz) {
        this.factoryRepository.addIgnoredClass(clazz);
        return this;
    }

    public <T extends ClassFactory> FatBoy hint(Class<T> factoryClass, FactoryHint factoryHint) {
        this.findFactory(factoryClass).putHint(factoryHint);
        return this;
    }

    public <T> T create(Class<T> clazz) {
        return this.create(clazz, Maps.newHashMap());
    }

    public <T> T create(Class<T> clazz, Map<String, Object> overrides) {
        ClassFactory<T> factory = this.factoryRepository.getFactoryForClass(clazz);
        if (factory != null) {
            return factory.create(null);
        }
        if (clazz.isPrimitive()) {
            throw new ClassInstantiationException("Primitive has no factory: [" + clazz + "]");
        }
        if (clazz.isInterface()) {
            throw new ClassInstantiationException("Interface has no factory: [" + clazz + "]");
        }
        try {
            return this.createInstance(clazz, overrides, new Type[0]);
        }
        catch (ClassInstantiationException e) {
            throw (RuntimeException)ExceptionUtils.getRootCause((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object createGeneric(Type type, Field field) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            ClassFactory fieldFactory = this.factoryRepository.getFactoryForField(field);
            if (fieldFactory != null) {
                if (fieldFactory instanceof GenericClassFactory) {
                    return ((GenericClassFactory)fieldFactory).create(rawType, actualTypeArguments);
                }
                return fieldFactory.create(field);
            }
            GenericClassFactory factory = this.factoryRepository.getFactoryForGenericType(rawType, parameterizedType);
            if (factory != null) {
                return factory.create(rawType, actualTypeArguments);
            }
            return this.createInstance(rawType, Maps.newHashMap(), actualTypeArguments);
        }
        if (type instanceof Class) {
            if (((Class)type).isArray()) {
                GenericClassFactory classFactory = this.factoryRepository.getFactoryForGenericType((Class)type, ((Class)type).getComponentType());
                return classFactory.create((Class)type, null);
            }
            return this.create((Class)type);
        }
        throw new ClassInstantiationException("Unknown generic type: [" + type + "]");
    }

    public Object createGeneric(Type type) {
        return this.createGeneric(type, null);
    }

    private <T> T createInstance(Class<T> rawType, Map<String, Object> overrides, Type ... actualTypeArguments) {
        try {
            Constructor<T> constructor = ReflectionUtils.getDefaultOrFirstConstructor(rawType);
            constructor.setAccessible(true);
            List args = Arrays.asList(constructor.getGenericParameterTypes()).stream().map(this::createGeneric).collect(Collectors.toList());
            T instance = constructor.newInstance(args.toArray());
            return this.setFields(instance, overrides, actualTypeArguments);
        }
        catch (Exception e) {
            throw new ClassInstantiationException(e.getMessage(), e);
        }
    }

    private <T> T setFields(T instance, Map<String, Object> overrides, Type ... types) {
        ReflectionUtils.getAllDeclaredFields(instance.getClass()).stream().forEach(LambdaUtils.unchecked(field -> {
            field.setAccessible(true);
            if (overrides.containsKey(field.getName())) {
                field.set(instance, overrides.get(field.getName()));
                return;
            }
            if (!(field.getGenericType() instanceof Class)) {
                Type resolvedType = this.resolveType((Field)field, types, instance.getClass().getTypeParameters());
                field.set(instance, this.createGeneric(resolvedType, (Field)field));
                return;
            }
            ClassFactory factory = this.factoryRepository.getFactoryForField((Field)field);
            if (factory == null) {
                field.set(instance, this.create(field.getType()));
            } else {
                field.set(instance, factory.create((Field)field));
            }
        }));
        return instance;
    }

    private Type resolveType(Field field, Type[] types, Type[] genericTypes) {
        TypeResolver typeResolver = new TypeResolver();
        for (int x = 0; x < types.length; ++x) {
            typeResolver = typeResolver.where(genericTypes[x], types[x]);
        }
        return typeResolver.resolveType(field.getGenericType());
    }

    @FunctionalInterface
    public static interface FatBoyProvidedFactory<T> {
        public T create(FatBoy var1);
    }
}

