/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.fatboy;

import au.com.dius.fatboy.FatBoy;
import au.com.dius.fatboy.config.Configurer;
import au.com.dius.fatboy.factory.ClassFactory;
import au.com.dius.fatboy.factory.GenericClassFactory;
import au.com.dius.fatboy.factory.GenericTypeFactory;
import au.com.dius.fatboy.factory.collections.ArrayFactory;
import au.com.dius.fatboy.factory.collections.CollectionFactory;
import au.com.dius.fatboy.factory.collections.MapFactory;
import au.com.dius.fatboy.factory.impl.SimpleClassFactory;
import au.com.dius.fatboy.factory.impl.SimpleFieldFactory;
import au.com.dius.fatboy.factory.impl.SimpleGenericFieldFactory;
import au.com.dius.fatboy.factory.noop.NullFactory;
import au.com.dius.fatboy.factory.primitives.BooleanFactory;
import au.com.dius.fatboy.factory.primitives.EnumFactory;
import au.com.dius.fatboy.factory.primitives.IntFactory;
import au.com.dius.fatboy.factory.primitives.LongFactory;
import au.com.dius.fatboy.factory.primitives.StringFactory;
import au.com.dius.fatboy.factory.user.DateTimeFactory;
import au.com.dius.fatboy.factory.user.UUIDFactory;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

class FactoryRepository {
    private final List<ClassFactory> factories;
    private NullFactory nullFactory = new NullFactory();

    public FactoryRepository(FatBoy fatboy) {
        this.factories = Lists.newArrayList();
        this.factories.add(new StringFactory());
        this.factories.add(new IntFactory());
        this.factories.add(new BooleanFactory());
        this.factories.add(new LongFactory());
        this.factories.add(new EnumFactory());
        this.factories.add(new ArrayFactory(fatboy));
        this.factories.add(new CollectionFactory(fatboy));
        this.factories.add(new MapFactory(fatboy));
        this.factories.add(new UUIDFactory());
        this.factories.add(new DateTimeFactory());
        this.applyHints();
    }

    private void applyHints() {
        this.factories.forEach(Configurer::applyHints);
    }

    public <T> void addFactory(ClassFactory<T> classFactory) {
        this.factories.add(0, classFactory);
    }

    public <T> void addFactory(Class<T> clazz, Supplier<T> supplier) {
        this.addFactory(new SimpleClassFactory<Object>(clazz, (raw, actual) -> supplier.get()));
    }

    public <T> void addFactory(Field field, Supplier<T> factory) {
        this.addFactory(new SimpleFieldFactory<T>(field, factory));
    }

    public <T> void addFactory(Class<T> clazz, GenericTypeFactory<T> factory) {
        if (clazz.getTypeParameters().length == 0) {
            throw new IllegalArgumentException("Addition of a generic class factory must only be used for generic classes");
        }
        this.addFactory(new SimpleClassFactory<T>(clazz, factory));
    }

    public <T> void addFactory(Field field, GenericTypeFactory<T> factory) {
        if (field.getType().getTypeParameters().length == 0) {
            throw new IllegalArgumentException("Addition of a generic field factory must only be used for generic fields");
        }
        this.addFactory(new SimpleGenericFieldFactory<T>(field, factory));
    }

    public void addIgnoredClass(Class<?> clazz) {
        this.nullFactory.addIgnoredClass(clazz);
    }

    public <T extends ClassFactory> ClassFactory findFactory(Class<T> clazz) {
        return this.getFactory(x -> x.getClass().isAssignableFrom(clazz));
    }

    public <T> ClassFactory<T> getFactoryForClass(Class<T> clazz) {
        return this.getFactory(x -> x.supports(clazz));
    }

    public <T> ClassFactory<T> getFactoryForField(Field field) {
        if (field == null) {
            return null;
        }
        return this.getFactory(x -> x.supports(field));
    }

    public GenericClassFactory getFactoryForGenericType(Class clazz, Type genericType) {
        return (GenericClassFactory)this.getFactory(x -> x instanceof GenericClassFactory && ((GenericClassFactory)x).supports(clazz, genericType));
    }

    private <T> ClassFactory<T> getFactory(Predicate<ClassFactory> predicate) {
        if (predicate.test(this.nullFactory)) {
            return this.nullFactory;
        }
        return this.factories.stream().filter(predicate).findFirst().orElse(null);
    }
}

