/*
 * Decompiled with CFR 0.152.
 */
package au.com.dardle.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.FrameLayout;
import au.com.dardle.widget.R;

public class LabelLayout
extends FrameLayout {
    private int mLabelDistance;
    private int mLabelHeight;
    private Drawable mLabelBackground;
    private Gravity mLabelGravity;
    private String mLabelText;
    private int mLabelTextSize;
    private int mLabelTextColor;
    private final Paint mTextPaint;

    public LabelLayout(Context context) {
        this(context, null);
    }

    public LabelLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LabelLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        TintTypedArray tintTypedArray = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.LabelLayout);
        this.mLabelDistance = tintTypedArray.getDimensionPixelSize(R.styleable.LabelLayout_labelDistance, 0);
        this.mLabelHeight = tintTypedArray.getDimensionPixelSize(R.styleable.LabelLayout_labelHeight, 0);
        this.mLabelBackground = tintTypedArray.getDrawable(R.styleable.LabelLayout_labelBackground);
        this.mLabelGravity = Gravity.values()[tintTypedArray.getInteger(R.styleable.LabelLayout_labelGravity, Gravity.TOP_LEFT.ordinal())];
        this.mLabelText = tintTypedArray.getString(R.styleable.LabelLayout_labelText);
        this.mLabelTextSize = tintTypedArray.getDimensionPixelSize(R.styleable.LabelLayout_labelTextSize, (int)new Paint().getTextSize());
        this.mLabelTextColor = tintTypedArray.getColor(R.styleable.LabelLayout_labelTextColor, -16777216);
        tintTypedArray.recycle();
        this.mTextPaint = new Paint();
        this.mTextPaint.setDither(true);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mTextPaint.setStrokeCap(Paint.Cap.SQUARE);
    }

    public void onDrawForeground(Canvas canvas) {
        super.onDrawForeground(canvas);
        Path bisectorPath = new Path();
        int[] bisectorCoordinates = this.calculateBisectorCoordinates(this.mLabelDistance, this.mLabelHeight, this.mLabelGravity);
        bisectorPath.moveTo((float)bisectorCoordinates[0], (float)bisectorCoordinates[1]);
        bisectorPath.lineTo((float)bisectorCoordinates[2], (float)bisectorCoordinates[3]);
        int[] centerCoordinate = this.calculateCenterCoordinate(this.mLabelDistance, this.mLabelHeight, this.mLabelGravity);
        int labelHalfWidth = this.calculateWidth(this.mLabelDistance, this.mLabelHeight) / 2;
        int labelHalfHeight = this.mLabelHeight / 2;
        Rect labelRect = new Rect(centerCoordinate[0] - labelHalfWidth, centerCoordinate[1] - labelHalfHeight, centerCoordinate[0] + labelHalfWidth, centerCoordinate[1] + labelHalfHeight);
        this.mLabelBackground.setBounds(this.calculateBackgroundBounds(this.mLabelBackground, labelRect));
        canvas.save();
        canvas.rotate(this.calculateRotateDegree(this.mLabelGravity), (float)centerCoordinate[0], (float)centerCoordinate[1]);
        this.mLabelBackground.draw(canvas);
        canvas.restore();
        this.mTextPaint.setTextSize((float)this.mLabelTextSize);
        this.mTextPaint.setColor(this.mLabelTextColor);
        float[] offsets = this.calculateTextOffsets(this.mLabelText, this.mTextPaint, this.mLabelDistance, this.mLabelHeight, this.mLabelGravity);
        canvas.drawTextOnPath(this.mLabelText, bisectorPath, offsets[0], offsets[1], this.mTextPaint);
    }

    public int getLabelDistance() {
        return this.mLabelDistance;
    }

    public void setLabelDistance(int labelDistance) {
        this.mLabelDistance = labelDistance;
        this.invalidate();
    }

    public int getLabelHeight() {
        return this.mLabelHeight;
    }

    public void setLabelHeight(int labelHeight) {
        this.mLabelHeight = labelHeight;
        this.invalidate();
    }

    public Drawable getLabelBackground() {
        return this.mLabelBackground;
    }

    public void setLabelBackground(Drawable labelBackground) {
        this.mLabelBackground = labelBackground;
        this.invalidate();
    }

    public Gravity getLabelGravity() {
        return this.mLabelGravity;
    }

    public void setLabelGravity(Gravity labelGravity) {
        this.mLabelGravity = labelGravity;
        this.invalidate();
    }

    public String getLabelText() {
        return this.mLabelText;
    }

    public void setLabelText(String labelText) {
        this.mLabelText = labelText;
        this.invalidate();
    }

    public int getLabelTextSize() {
        return this.mLabelTextSize;
    }

    public void setLabelTextSize(int labelTextSize) {
        this.mLabelTextSize = labelTextSize;
        this.invalidate();
    }

    public int getLabelTextColor() {
        return this.mLabelTextColor;
    }

    public void setLabelTextColor(int labelTextColor) {
        this.mLabelTextColor = labelTextColor;
        this.invalidate();
    }

    private int calculateBisectorIntersectAbsolutePosition(int distance, int height) {
        return (int)(Math.sqrt(2.0) * (double)(distance + height / 2));
    }

    private int[] calculateBisectorCoordinates(int distance, int height, Gravity gravity) {
        int bisectorEndY;
        int bisectorEndX;
        int bisectorStartX;
        int bisectorStartY;
        int bisectorIntersectAbsolutePosition = this.calculateBisectorIntersectAbsolutePosition(distance, height);
        int[] results = new int[4];
        switch (gravity) {
            case TOP_RIGHT: {
                bisectorStartY = 0;
                bisectorStartX = this.getMeasuredWidth() - bisectorIntersectAbsolutePosition;
                bisectorEndX = this.getMeasuredWidth();
                bisectorEndY = bisectorIntersectAbsolutePosition;
                break;
            }
            case BOTTOM_RIGHT: {
                bisectorStartX = this.getMeasuredWidth() - bisectorIntersectAbsolutePosition;
                bisectorStartY = this.getMeasuredHeight();
                bisectorEndX = this.getMeasuredWidth();
                bisectorEndY = this.getMeasuredHeight() - bisectorIntersectAbsolutePosition;
                break;
            }
            case BOTTOM_LEFT: {
                bisectorStartX = 0;
                bisectorStartY = this.getMeasuredHeight() - bisectorIntersectAbsolutePosition;
                bisectorEndX = bisectorIntersectAbsolutePosition;
                bisectorEndY = this.getMeasuredHeight();
                break;
            }
            default: {
                bisectorStartX = 0;
                bisectorStartY = bisectorIntersectAbsolutePosition;
                bisectorEndX = bisectorIntersectAbsolutePosition;
                bisectorEndY = 0;
            }
        }
        results[0] = bisectorStartX;
        results[1] = bisectorStartY;
        results[2] = bisectorEndX;
        results[3] = bisectorEndY;
        return results;
    }

    private float[] calculateTextOffsets(String text, Paint paint, int distance, int height, Gravity gravity) {
        float[] offsets = new float[2];
        Rect textBounds = new Rect();
        paint.getTextBounds(text, 0, text.length(), textBounds);
        float hOffset = (float)((double)this.calculateBisectorIntersectAbsolutePosition(distance, height) / Math.sqrt(2.0) - (double)textBounds.width() / 2.0);
        float vOffset = distance >= height ? (float)textBounds.height() * 0.5f : (gravity.equals((Object)Gravity.TOP_LEFT) || gravity.equals((Object)Gravity.TOP_RIGHT) ? (float)textBounds.height() * (0.5f + (float)(height - distance) / (float)height * 0.5f) : (float)textBounds.height() * (0.5f - (float)(height - distance) / (float)height * 0.5f));
        Log.d((String)LabelLayout.class.getSimpleName(), (String)String.format("%d, %d, %f", distance, height, Float.valueOf(vOffset)));
        offsets[0] = hOffset;
        offsets[1] = vOffset;
        return offsets;
    }

    private int[] calculateCenterCoordinate(int distance, int height, Gravity gravity) {
        int y;
        int x;
        int[] results = new int[2];
        int centerAbsolutePosition = this.calculateCenterAbsolutePosition(distance, height);
        switch (gravity) {
            default: {
                x = centerAbsolutePosition;
                y = centerAbsolutePosition;
                break;
            }
            case TOP_RIGHT: {
                x = this.getMeasuredWidth() - centerAbsolutePosition;
                y = centerAbsolutePosition;
                break;
            }
            case BOTTOM_RIGHT: {
                x = this.getMeasuredWidth() - centerAbsolutePosition;
                y = this.getMeasuredHeight() - centerAbsolutePosition;
                break;
            }
            case BOTTOM_LEFT: {
                x = centerAbsolutePosition;
                y = this.getMeasuredHeight() - centerAbsolutePosition;
            }
        }
        results[0] = x;
        results[1] = y;
        return results;
    }

    private int calculateCenterAbsolutePosition(int distance, int height) {
        return (int)((double)(distance + height / 2) / Math.sqrt(2.0));
    }

    private int calculateWidth(int distance, int height) {
        return 2 * (distance + height);
    }

    private Rect calculateBackgroundBounds(Drawable drawable, Rect labelRect) {
        Rect rect;
        if (drawable instanceof ColorDrawable) {
            rect = new Rect(labelRect);
        } else {
            rect = new Rect();
            if (drawable.getIntrinsicWidth() <= labelRect.width() && drawable.getIntrinsicHeight() <= labelRect.height()) {
                rect.left = labelRect.centerX() - drawable.getIntrinsicWidth() / 2;
                rect.top = labelRect.centerY() - drawable.getIntrinsicHeight() / 2;
                rect.right = labelRect.centerX() + drawable.getIntrinsicWidth() / 2;
                rect.bottom = labelRect.centerY() + drawable.getIntrinsicHeight() / 2;
            } else {
                int height;
                int width;
                int ratio = drawable.getIntrinsicWidth() / drawable.getIntrinsicHeight();
                if (drawable.getIntrinsicWidth() / drawable.getIntrinsicHeight() >= labelRect.width() / labelRect.height()) {
                    width = labelRect.width();
                    height = labelRect.width() / ratio;
                } else {
                    width = labelRect.height() * ratio;
                    height = labelRect.height();
                }
                rect.left = labelRect.centerX() - width / 2;
                rect.top = labelRect.centerY() - height / 2;
                rect.right = labelRect.centerX() + width / 2;
                rect.bottom = labelRect.centerY() + height / 2;
            }
        }
        return rect;
    }

    private float calculateRotateDegree(Gravity gravity) {
        float degree;
        switch (gravity) {
            default: {
                degree = -45.0f;
                break;
            }
            case TOP_RIGHT: 
            case BOTTOM_LEFT: {
                degree = 45.0f;
            }
        }
        return degree;
    }

    public static enum Gravity {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT;

    }
}

