/*
 * Decompiled with CFR 0.152.
 */
package au.com.dardle.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.FrameLayout;
import au.com.dardle.widget.R;

public class LabelLayout
extends FrameLayout {
    private int mLabelDistance;
    private int mLabelHeight;
    private int mLabelBackgroundColor;
    private Gravity mLabelGravity;
    private String mLabelText;
    private int mLabelTextSize;
    private int mLabelTextColor;
    private final Paint mBackgroundPaint;
    private final Paint mTextPaint;

    public LabelLayout(Context context) {
        this(context, null);
    }

    public LabelLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LabelLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        TintTypedArray tintTypedArray = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.LabelLayout);
        this.mLabelDistance = tintTypedArray.getDimensionPixelSize(R.styleable.LabelLayout_labelDistance, 0);
        this.mLabelHeight = tintTypedArray.getDimensionPixelSize(R.styleable.LabelLayout_labelHeight, 0);
        this.mLabelBackgroundColor = tintTypedArray.getColor(R.styleable.LabelLayout_labelBackground, new Paint().getColor());
        this.mLabelGravity = Gravity.values()[tintTypedArray.getInteger(R.styleable.LabelLayout_labelGravity, Gravity.TOP_LEFT.ordinal())];
        this.mLabelText = tintTypedArray.getString(R.styleable.LabelLayout_labelText);
        this.mLabelTextSize = tintTypedArray.getDimensionPixelSize(R.styleable.LabelLayout_labelTextSize, (int)new Paint().getTextSize());
        this.mLabelTextColor = tintTypedArray.getColor(R.styleable.LabelLayout_labelTextColor, -16777216);
        tintTypedArray.recycle();
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setDither(true);
        this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mBackgroundPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.mTextPaint = new Paint();
        this.mTextPaint.setDither(true);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mTextPaint.setStrokeCap(Paint.Cap.SQUARE);
    }

    public void onDrawForeground(Canvas canvas) {
        super.onDrawForeground(canvas);
        Path bisectorPath = new Path();
        int[] bisectorCoordinates = this.calculateBisectorCoordinates(this.mLabelDistance, this.mLabelHeight, this.mLabelGravity);
        bisectorPath.moveTo((float)bisectorCoordinates[0], (float)bisectorCoordinates[1]);
        bisectorPath.lineTo((float)bisectorCoordinates[2], (float)bisectorCoordinates[3]);
        this.mBackgroundPaint.setStrokeWidth((float)this.mLabelHeight);
        this.mBackgroundPaint.setColor(this.mLabelBackgroundColor);
        canvas.drawPath(bisectorPath, this.mBackgroundPaint);
        this.mTextPaint.setTextSize((float)this.mLabelTextSize);
        this.mTextPaint.setColor(this.mLabelTextColor);
        float[] offsets = this.calculateTextOffsets(this.mLabelText, this.mTextPaint, this.mLabelDistance, this.mLabelHeight);
        canvas.drawTextOnPath(this.mLabelText, bisectorPath, offsets[0], offsets[1], this.mTextPaint);
    }

    public int getLabelDistance() {
        return this.mLabelDistance;
    }

    public void setLabelDistance(int labelDistance) {
        this.mLabelDistance = labelDistance;
        this.invalidate();
    }

    public int getLabelHeight() {
        return this.mLabelHeight;
    }

    public void setLabelHeight(int labelHeight) {
        this.mLabelHeight = labelHeight;
        this.invalidate();
    }

    public int getLabelBackgroundColor() {
        return this.mLabelBackgroundColor;
    }

    public void setLabelBackgroundColor(int labelBackgroundColor) {
        this.mLabelBackgroundColor = labelBackgroundColor;
        this.invalidate();
    }

    public Gravity getLabelGravity() {
        return this.mLabelGravity;
    }

    public void setLabelGravity(Gravity labelGravity) {
        this.mLabelGravity = labelGravity;
        this.invalidate();
    }

    public String getLabelText() {
        return this.mLabelText;
    }

    public void setLabelText(String labelText) {
        this.mLabelText = labelText;
        this.invalidate();
    }

    public int getLabelTextSize() {
        return this.mLabelTextSize;
    }

    public void setLabelTextSize(int labelTextSize) {
        this.mLabelTextSize = labelTextSize;
        this.invalidate();
    }

    public int getLabelTextColor() {
        return this.mLabelTextColor;
    }

    public void setLabelTextColor(int labelTextColor) {
        this.mLabelTextColor = labelTextColor;
        this.invalidate();
    }

    private int calculateBisectorIntersectPosition(int distance, int height) {
        return (int)(Math.sqrt(2.0) * (double)(distance + height / 2));
    }

    private int[] calculateBisectorCoordinates(int distance, int height, Gravity gravity) {
        int bisectorEndY;
        int bisectorEndX;
        int bisectorStartX;
        int bisectorStartY;
        int bisectorIntersectPosition = this.calculateBisectorIntersectPosition(distance, height);
        int[] results = new int[4];
        switch (gravity) {
            case TOP_RIGHT: {
                bisectorStartY = 0;
                bisectorStartX = this.getMeasuredWidth() - bisectorIntersectPosition;
                bisectorEndX = this.getMeasuredWidth();
                bisectorEndY = bisectorIntersectPosition;
                break;
            }
            case BOTTOM_RIGHT: {
                bisectorStartX = this.getMeasuredWidth() - bisectorIntersectPosition;
                bisectorStartY = this.getMeasuredHeight();
                bisectorEndX = this.getMeasuredWidth();
                bisectorEndY = this.getMeasuredHeight() - bisectorIntersectPosition;
                break;
            }
            case BOTTOM_LEFT: {
                bisectorStartX = 0;
                bisectorStartY = this.getMeasuredHeight() - bisectorIntersectPosition;
                bisectorEndX = bisectorIntersectPosition;
                bisectorEndY = this.getMeasuredHeight();
                break;
            }
            default: {
                bisectorStartX = 0;
                bisectorStartY = bisectorIntersectPosition;
                bisectorEndX = bisectorIntersectPosition;
                bisectorEndY = 0;
            }
        }
        results[0] = bisectorStartX;
        results[1] = bisectorStartY;
        results[2] = bisectorEndX;
        results[3] = bisectorEndY;
        return results;
    }

    private float[] calculateTextOffsets(String text, Paint paint, int distance, int height) {
        float[] offsets = new float[2];
        Rect textBounds = new Rect();
        paint.getTextBounds(text, 0, text.length(), textBounds);
        float hOffset = (float)((double)this.calculateBisectorIntersectPosition(distance, height) / Math.sqrt(2.0) - (double)textBounds.width() / 2.0);
        float vOffset = distance >= height ? (float)textBounds.height() * 0.5f : (float)textBounds.height() * ((float)(height - distance) / (float)height * 0.5f + 0.5f);
        Log.d((String)LabelLayout.class.getSimpleName(), (String)String.format("%d, %d, %f", distance, height, Float.valueOf(vOffset)));
        offsets[0] = hOffset;
        offsets[1] = vOffset;
        return offsets;
    }

    public static enum Gravity {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT;

    }
}

