/*
 * Decompiled with CFR 0.152.
 */
package au.com.dardle.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pools;
import android.support.v7.widget.TintTypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import au.com.dardle.widget.BadgeItem;
import au.com.dardle.widget.R;
import java.util.ArrayList;
import java.util.Iterator;

public class BadgeLayout
extends HorizontalScrollView {
    private static final Pools.Pool<Badge> sBadgePool = new Pools.SynchronizedPool(16);
    private final LinearLayout mContentContainer;
    private final ArrayList<Badge> mBadges = new ArrayList();
    private int mSpacing;
    private int mBadgeBackgroundResId;
    private int mBadgeContentSpacing;
    private BadgeTextPosition mBadgeTextPosition;
    private ColorStateList mBadgeTextColors;
    private int mBadgeTextSize;
    private final ArrayList<OnBadgeClickedListener> mOnBadgeClickedListeners = new ArrayList();
    private final View.OnClickListener mClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (view instanceof BadgeView) {
                BadgeView badgeView = (BadgeView)view;
                Badge badge = badgeView.mBadge;
                for (int i = BadgeLayout.this.mOnBadgeClickedListeners.size() - 1; i >= 0; --i) {
                    ((OnBadgeClickedListener)BadgeLayout.this.mOnBadgeClickedListeners.get(i)).onBadgeClicked(badge);
                }
            }
        }
    };
    private final Pools.Pool<BadgeView> mBadgeViewPool = new Pools.SimplePool(12);

    public BadgeLayout(Context context) {
        this(context, null);
    }

    public BadgeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BadgeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContentContainer = new LinearLayout(context);
        this.mContentContainer.setOrientation(0);
        this.mContentContainer.setGravity(16);
        super.addView((View)this.mContentContainer, 0, new ViewGroup.LayoutParams(-2, -2));
        TintTypedArray tintTypedArray = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.BadgeLayout);
        this.mSpacing = tintTypedArray.getDimensionPixelSize(R.styleable.BadgeLayout_spacing, 8);
        this.mBadgeContentSpacing = tintTypedArray.getDimensionPixelSize(R.styleable.BadgeLayout_badgeContentSpacing, 0);
        this.mBadgeBackgroundResId = tintTypedArray.getResourceId(R.styleable.BadgeLayout_badgeBackground, 0);
        this.mBadgeTextPosition = BadgeTextPosition.values()[tintTypedArray.getInt(R.styleable.BadgeLayout_badgeTextPosition, BadgeTextPosition.BOTTOM.ordinal())];
        if (tintTypedArray.hasValue(R.styleable.BadgeLayout_badgeTextColor)) {
            this.mBadgeTextColors = tintTypedArray.getColorStateList(R.styleable.BadgeLayout_badgeTextColor);
        }
        this.mBadgeTextSize = tintTypedArray.getDimensionPixelSize(R.styleable.BadgeLayout_badgeTextSize, -1);
        tintTypedArray.recycle();
    }

    public void addView(View child) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index) {
        this.addViewInternal(child);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    @NonNull
    public Badge newBadge() {
        Badge badge = (Badge)sBadgePool.acquire();
        if (badge == null) {
            badge = new Badge();
        }
        badge.mParent = this;
        badge.mView = this.createBadgeView(badge);
        return badge;
    }

    public void addBadge(@NonNull Badge badge) {
        if (badge.mParent != this) {
            throw new IllegalArgumentException("Badge belongs to a different BadgeLayout");
        }
        this.addBadgeView(badge);
        this.configureBadge(badge);
    }

    public void removeAllBadges() {
        for (int i = this.mContentContainer.getChildCount() - 1; i >= 0; --i) {
            this.removeBadgeViewAt(i);
        }
        Iterator<Badge> iterator = this.mBadges.iterator();
        while (iterator.hasNext()) {
            Badge badge = iterator.next();
            iterator.remove();
            sBadgePool.release((Object)badge);
        }
    }

    public void setSpacing(int spacing) {
        this.mSpacing = spacing;
        for (int i = 1; i < this.mBadges.size(); ++i) {
            Badge badge = this.mBadges.get(i);
            BadgeView view = badge.mView;
            if (view == null) continue;
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
            layoutParams.leftMargin = this.mSpacing;
        }
    }

    public void setBadgeContentSpacing(int badgeContentSpacing) {
        this.mBadgeContentSpacing = badgeContentSpacing;
        this.updateBadges();
    }

    public void setBadgeBackground(int badgeBackgroundResId) {
        this.mBadgeBackgroundResId = badgeBackgroundResId;
        this.updateBadges();
    }

    public void setBadgeTextPosition(BadgeTextPosition badgeTextPosition) {
        this.mBadgeTextPosition = badgeTextPosition;
        this.updateBadges();
    }

    public void setBadgeTextColor(ColorStateList badgeTextColor) {
        this.mBadgeTextColors = badgeTextColor;
        this.updateBadges();
    }

    public void addOnBadgeClickedListener(@NonNull OnBadgeClickedListener onBadgeClickedListener) {
        if (!this.mOnBadgeClickedListeners.contains(onBadgeClickedListener)) {
            this.mOnBadgeClickedListeners.add(onBadgeClickedListener);
        }
    }

    public void removeOnBadgeClickedListener(@NonNull OnBadgeClickedListener onBadgeClickedListener) {
        this.mOnBadgeClickedListeners.remove(onBadgeClickedListener);
    }

    private void addViewInternal(View child) {
        if (!(child instanceof BadgeItem)) {
            throw new IllegalArgumentException("Only BadgeItem instances can be added to BadgeLayout");
        }
        this.addBadgeFromItemView((BadgeItem)child);
    }

    private void addBadgeFromItemView(@NonNull BadgeItem badgeItem) {
        Badge badge = this.newBadge();
        badge.setText(badgeItem.mText);
        badge.setIcon(badgeItem.mIcon);
        badge.setEnabled(badgeItem.isEnabled());
        badge.setSelected(badgeItem.isSelected());
        this.addBadge(badge);
    }

    private BadgeView createBadgeView(@NonNull Badge badge) {
        BadgeView badgeView = (BadgeView)((Object)this.mBadgeViewPool.acquire());
        if (badgeView == null) {
            badgeView = new BadgeView(this.getContext());
        }
        badgeView.setBadge(badge);
        return badgeView;
    }

    private void addBadgeView(Badge badge) {
        BadgeView badgeView = badge.mView;
        if (badgeView != null) {
            if (badgeView.getParent() != null) {
                this.mContentContainer.removeView((View)badgeView);
            }
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            if (this.mContentContainer.getChildCount() > 0) {
                layoutParams.leftMargin = this.mSpacing;
            }
            badgeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mContentContainer.addView((View)badgeView);
        }
    }

    private void configureBadge(Badge badge) {
        this.mBadges.add(badge);
        if (badge.mView != null) {
            badge.mView.setOnClickListener(this.mClickListener);
        }
    }

    private void updateBadges() {
        for (Badge badge : this.mBadges) {
            badge.updateView();
        }
    }

    private void removeBadgeViewAt(int position) {
        BadgeView badgeView = (BadgeView)this.mContentContainer.getChildAt(position);
        this.mContentContainer.removeViewAt(position);
        if (badgeView != null) {
            this.mBadgeViewPool.release((Object)badgeView);
        }
        this.requestLayout();
    }

    private class BadgeView
    extends LinearLayout {
        private Badge mBadge;
        private final ImageView mImageView;
        private final TextView mTextView;

        public BadgeView(Context context) {
            super(context);
            this.mImageView = new ImageView(context);
            this.mTextView = new TextView(context);
            this.mTextView.setLines(1);
            this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
            this.update();
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            this.mImageView.setSelected(selected);
            this.mTextView.setSelected(selected);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.mImageView.setEnabled(enabled);
            this.mTextView.setEnabled(enabled);
        }

        private void setBadge(@Nullable Badge badge) {
            if (badge != this.mBadge) {
                this.mBadge = badge;
                this.update();
            }
        }

        final void update() {
            this.updateLayout();
            this.updateContent();
        }

        private void updateLayout() {
            this.setGravity(17);
            this.setBackgroundResource(BadgeLayout.this.mBadgeBackgroundResId);
            if (BadgeLayout.this.mBadgeTextPosition == BadgeTextPosition.LEFT || BadgeLayout.this.mBadgeTextPosition == BadgeTextPosition.RIGHT) {
                this.setOrientation(0);
            } else {
                this.setOrientation(1);
            }
            this.removeAllViews();
            int textViewIndex = 0;
            int imageViewIndex = 0;
            LinearLayout.LayoutParams textViewLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            LinearLayout.LayoutParams imageViewLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            switch (BadgeLayout.this.mBadgeTextPosition) {
                case LEFT: {
                    imageViewIndex = 1;
                    textViewIndex = 0;
                    textViewLayoutParams.rightMargin = BadgeLayout.this.mBadgeContentSpacing;
                    break;
                }
                case TOP: {
                    imageViewIndex = 1;
                    textViewIndex = 0;
                    textViewLayoutParams.bottomMargin = BadgeLayout.this.mBadgeContentSpacing;
                    break;
                }
                case RIGHT: {
                    imageViewIndex = 0;
                    textViewIndex = 1;
                    textViewLayoutParams.leftMargin = BadgeLayout.this.mBadgeContentSpacing;
                    break;
                }
                case BOTTOM: {
                    imageViewIndex = 0;
                    textViewIndex = 1;
                    textViewLayoutParams.topMargin = BadgeLayout.this.mBadgeContentSpacing;
                }
            }
            this.addView((View)this.mImageView, imageViewIndex, (ViewGroup.LayoutParams)imageViewLayoutParams);
            this.addView((View)this.mTextView, textViewIndex, (ViewGroup.LayoutParams)textViewLayoutParams);
        }

        private void updateContent() {
            if (this.mBadge != null) {
                this.mImageView.setImageDrawable(this.mBadge.mIcon);
                this.mTextView.setText(this.mBadge.mText);
                if (BadgeLayout.this.mBadgeTextColors != null) {
                    this.mTextView.setTextColor(BadgeLayout.this.mBadgeTextColors);
                }
                if (BadgeLayout.this.mBadgeTextSize != -1) {
                    this.mTextView.setTextSize((float)BadgeLayout.this.mBadgeTextSize);
                }
                if (TextUtils.isEmpty((CharSequence)this.mTextView.getText())) {
                    this.mTextView.setVisibility(8);
                } else {
                    this.mTextView.setVisibility(0);
                }
                this.setSelected(this.mBadge.mSelected);
                this.setEnabled(this.mBadge.mEnabled);
            }
        }
    }

    public static enum BadgeTextPosition {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM;

    }

    public static final class Badge {
        private Drawable mIcon;
        private CharSequence mText;
        private boolean mSelected = false;
        private boolean mEnabled = true;
        @Nullable
        private BadgeLayout mParent;
        @Nullable
        private BadgeView mView;

        private Badge() {
        }

        @NonNull
        public Badge setText(@Nullable CharSequence text) {
            this.mText = text;
            this.updateView();
            return this;
        }

        @NonNull
        public Badge setIcon(@Nullable Drawable icon) {
            this.mIcon = icon;
            this.updateView();
            return this;
        }

        @NonNull
        public Badge setSelected(boolean selected) {
            this.mSelected = selected;
            this.updateView();
            return this;
        }

        @NonNull
        public Badge setEnabled(boolean enabled) {
            this.mEnabled = enabled;
            this.updateView();
            return this;
        }

        @Nullable
        public CharSequence getText() {
            return this.mText;
        }

        private void updateView() {
            if (this.mView != null) {
                this.mView.update();
            }
        }
    }

    public static interface OnBadgeClickedListener {
        public void onBadgeClicked(Badge var1);
    }
}

