/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tag;

import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.bindings.IterableExpansionBindings;
import au.com.codeka.carrot.bindings.SingletonBindings;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.StatementParser;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.tmpl.TagNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nullable;

public class SetTag
extends Tag {
    private List<Identifier> identifiers;
    @Nullable
    private Term expression;

    @Override
    public boolean isBlockTag() {
        return this.expression == null;
    }

    @Override
    public void parseStatement(StatementParser stmtParser) throws CarrotException {
        this.identifiers = stmtParser.parseIdentifierList();
        if (stmtParser.isAssignment()) {
            this.expression = stmtParser.parseTerm();
        } else if (this.identifiers.size() != 1) {
            throw new CarrotException("Block assignment does not support unpacking.");
        }
    }

    @Override
    public void render(CarrotEngine engine, Writer writer, TagNode tagNode, Scope scope) throws CarrotException, IOException {
        if (this.expression == null) {
            StringWriter stringWriter = new StringWriter();
            tagNode.renderChildren(engine, stringWriter, scope);
            scope.extendCurrent(new SingletonBindings(this.identifiers.get(0).evaluate(), stringWriter.toString()));
        } else if (this.identifiers.size() == 1) {
            scope.extendCurrent(new SingletonBindings(this.identifiers.get(0).evaluate(), this.expression.evaluate(engine.getConfig(), scope)));
        } else {
            scope.extendCurrent(new IterableExpansionBindings(this.identifiers, (Iterable)this.expression.evaluate(engine.getConfig(), scope)));
        }
    }
}

