/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tag;

import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.bindings.EmptyBindings;
import au.com.codeka.carrot.bindings.IterableExpansionBindings;
import au.com.codeka.carrot.bindings.SingletonBindings;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.StatementParser;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.tmpl.TagNode;
import au.com.codeka.carrot.util.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nullable;

public class IncludeTag
extends Tag {
    private Term templateNameExpr;
    @Nullable
    private List<Identifier> identifiers;
    @Nullable
    private Term expression;

    @Override
    public void parseStatement(StatementParser stmtParser) throws CarrotException {
        this.templateNameExpr = stmtParser.parseTerm();
        this.identifiers = stmtParser.maybeParseIdentifierList();
        if (this.identifiers != null) {
            stmtParser.parseToken(TokenType.ASSIGNMENT);
            this.expression = stmtParser.parseTerm();
        }
    }

    @Override
    public void render(CarrotEngine engine, Writer writer, TagNode tagNode, Scope scope) throws CarrotException, IOException {
        String templateName = this.templateNameExpr.evaluate(engine.getConfig(), scope).toString();
        ResourceName resourceName = engine.getConfig().getResourceLocator().findResource(null, templateName);
        if (this.identifiers != null && this.identifiers.size() == 1) {
            Preconditions.checkNotNull(this.expression);
            String identifier = Preconditions.checkNotNull(this.identifiers.get(0).evaluate());
            scope.push(new SingletonBindings(identifier, this.expression.evaluate(engine.getConfig(), scope)));
        } else if (this.identifiers != null) {
            Preconditions.checkNotNull(this.expression);
            scope.push(new IterableExpansionBindings(this.identifiers, this.evaluateIterable(this.expression, engine, scope)));
        } else {
            scope.push(new EmptyBindings());
        }
        engine.process(writer, resourceName, scope);
        scope.pop();
    }

    private Iterable<Object> evaluateIterable(Term expression, CarrotEngine engine, Scope scope) throws CarrotException {
        return (Iterable)expression.evaluate(engine.getConfig(), scope);
    }
}

