/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.resource;

import au.com.codeka.carrot.resource.ResourceName;
import javax.annotation.Nullable;

public class ResourcePointer {
    @Nullable
    private final ResourceName resourceName;
    private final String line;
    private final int lineNo;
    private final int col;

    public ResourcePointer(ResourceName resourceName) {
        this.resourceName = resourceName;
        this.line = null;
        this.lineNo = 0;
        this.col = 0;
    }

    public ResourcePointer(ResourceName resourceName, String line, int lineNo, int col) {
        this.resourceName = resourceName;
        this.line = line;
        this.lineNo = lineNo;
        this.col = col;
    }

    public ResourcePointer nextCol() {
        return new ResourcePointer(this.resourceName, this.line, this.lineNo, this.col + 1);
    }

    public ResourcePointer nextLine(String line) {
        return new ResourcePointer(this.resourceName, line, this.lineNo + 1, 1);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String toString() {
        String str = (this.resourceName == null ? "???" : this.resourceName.getName()) + "\n";
        String prefix = Integer.toString(this.lineNo) + ": ";
        str = str + prefix + this.line;
        str = str + "\n";
        str = str + new String(new char[prefix.length() + this.col - 1]).replace('\u0000', ' ');
        str = str + "^";
        return str;
    }
}

