/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.resource;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.resource.AbstractResourceName;
import au.com.codeka.carrot.resource.ResourceLocator;
import au.com.codeka.carrot.resource.ResourceName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.Nullable;

public class FileResourceLocator
implements ResourceLocator {
    private final Configuration config;
    private final File baseFile;

    public FileResourceLocator(Configuration config, String basePath) {
        this.config = config;
        this.baseFile = new File(basePath);
    }

    @Override
    public ResourceName findResource(@Nullable ResourceName parent, String name) throws CarrotException {
        File file = new File(name);
        if (file.isAbsolute()) {
            return new FileResourceName(null, file.getName(), file);
        }
        if (parent != null && (file = new File(((FileResourceName)parent).getFile(), name)).exists() && file.isFile()) {
            return new FileResourceName(parent, name, file);
        }
        file = new File(this.baseFile, name);
        if (file.exists() && file.isFile()) {
            return new FileResourceName(null, name, file);
        }
        throw new CarrotException(new FileNotFoundException("[parent = " + parent + "] [name = " + name + "] [base = " + this.baseFile + "]"));
    }

    @Override
    public ResourceName findResource(String name) throws CarrotException {
        return this.findResource(null, name);
    }

    @Override
    public long getModifiedTime(ResourceName resourceName) throws CarrotException {
        return ((FileResourceName)resourceName).getFile().lastModified();
    }

    @Override
    public Reader getReader(ResourceName resourceName) throws CarrotException {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(((FileResourceName)resourceName).getFile()), this.config.getEncoding());
        }
        catch (IOException e) {
            throw new CarrotException(e);
        }
    }

    private static class FileResourceName
    extends AbstractResourceName {
        private final File file;

        public FileResourceName(@Nullable ResourceName parent, String name, File file) {
            super(parent, name);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public ResourceName getParent() {
            File parent = this.file.getParentFile();
            return new FileResourceName(null, parent.getName(), parent);
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof FileResourceName && ((FileResourceName)other).file.equals(this.file);
        }
    }

    public static class Builder
    implements ResourceLocator.Builder {
        private String basePath;

        public Builder() {
        }

        public Builder(String basePath) {
            this.basePath = basePath;
        }

        public Builder setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public ResourceLocator build(Configuration config) {
            return new FileResourceLocator(config, this.basePath);
        }
    }
}

