/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr.binary;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.expr.Lazy;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.binary.BinaryOperator;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.dmfs.iterables.decorators.Flattened;
import org.dmfs.iterators.SingletonIterator;

public final class IterationOperator
implements BinaryOperator {
    @Override
    public Object apply(Object left, Lazy right) throws CarrotException {
        return new Flattened(new Iterable[]{Collections.singleton(left), new LazyIterable(right)});
    }

    public String toString() {
        return TokenType.COMMA.toString();
    }

    private final class LazyIterable
    implements Iterable<Object> {
        private final Lazy value;

        public LazyIterable(Lazy value) {
            this.value = value;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            try {
                Object val = this.value.value();
                return val instanceof Iterable ? ((Iterable)val).iterator() : new SingletonIterator(val);
            }
            catch (CarrotException e) {
                throw new IllegalStateException("can't iterate elements", e);
            }
        }
    }
}

