/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr.accessible;

import au.com.codeka.carrot.Bindings;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.expr.Lazy;
import au.com.codeka.carrot.expr.binary.BinaryOperator;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.dmfs.iterables.decorators.Filtered;
import org.dmfs.iterators.Filter;
import org.dmfs.iterators.filters.Skip;

public final class AccessOperator
implements BinaryOperator {
    @Override
    public Object apply(Object left, Lazy right) throws CarrotException {
        return this.access(left, right.value());
    }

    private Object access(Object value, Object accessor) throws CarrotException {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.get(accessor);
        }
        if (value instanceof Bindings) {
            Bindings bindings = (Bindings)value;
            return bindings.resolve(accessor.toString());
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.get(ValueHelper.toNumber(accessor).intValue());
        }
        if (value.getClass().isArray()) {
            return Array.get(value, ValueHelper.toNumber(accessor).intValue());
        }
        if (value instanceof Iterable && Number.class.isAssignableFrom(accessor.getClass())) {
            return new Filtered((Iterable)value, (Filter)new Skip(ValueHelper.toNumber(accessor).intValue())).iterator().next();
        }
        try {
            String name = accessor.toString();
            Field field = value.getClass().getField(name);
            field.setAccessible(true);
            return field.get(value);
        }
        catch (IllegalAccessException | NoSuchFieldException name) {
            try {
                String name2 = accessor.toString();
                Method method = value.getClass().getMethod(name2, new Class[0]);
                method.setAccessible(true);
                return method.invoke(value, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException name2) {
                try {
                    String name3 = accessor.toString();
                    name3 = Character.toUpperCase(name3.charAt(0)) + name3.substring(1);
                    name3 = "get" + name3;
                    Method method = value.getClass().getMethod(name3, new Class[0]);
                    method.setAccessible(true);
                    return method.invoke(value, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CarrotException(e);
                }
            }
        }
    }
}

