/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.util.LineReader;
import java.io.IOException;
import java.util.ArrayDeque;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Tokenizer {
    private final LineReader reader;
    @Nullable
    private Character lookahead;
    private ArrayDeque<Token> tokens = new ArrayDeque();

    public Tokenizer(LineReader reader) throws CarrotException {
        this.reader = reader;
        this.next();
    }

    public boolean accept(TokenType ... types) throws CarrotException {
        Token token = this.tokens.peek();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != token.getType()) continue;
            return true;
        }
        return false;
    }

    public boolean accept(int offset, TokenType type) throws CarrotException {
        if (offset == 0) {
            return this.accept(type);
        }
        while (this.tokens.size() <= offset) {
            this.next();
        }
        Token[] array = this.tokens.toArray(new Token[this.tokens.size()]);
        return array[offset].getType() == type;
    }

    @Nonnull
    public Token expect(TokenType ... types) throws CarrotException {
        for (TokenType type : types) {
            if (this.tokens.peek().getType() != type) continue;
            Token t = this.tokens.remove();
            this.next();
            return t;
        }
        StringBuilder typeString = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                if (i == types.length - 1) {
                    typeString.append(" or ");
                } else {
                    typeString.append(", ");
                }
            }
            typeString.append((Object)types[i]);
        }
        throw new CarrotException("Expected token of type " + typeString + ", got " + (Object)((Object)this.tokens.peek().getType()), this.reader.getPointer());
    }

    public void end() throws CarrotException {
        this.expect(TokenType.EOF);
    }

    public CarrotException unexpected(String msg) {
        return new CarrotException(String.format("%s, found: %s", msg, this.tokens.peek()), this.reader.getPointer());
    }

    private void next() throws CarrotException {
        Token token;
        int ch = this.nextChar();
        while (Character.isWhitespace(ch)) {
            ch = this.nextChar();
        }
        if (ch < 0) {
            this.tokens.add(new Token(TokenType.EOF));
            return;
        }
        block0 : switch (ch) {
            case 40: {
                token = new Token(TokenType.LPAREN);
                break;
            }
            case 41: {
                token = new Token(TokenType.RPAREN);
                break;
            }
            case 91: {
                token = new Token(TokenType.LSQUARE);
                break;
            }
            case 93: {
                token = new Token(TokenType.RSQUARE);
                break;
            }
            case 44: {
                token = new Token(TokenType.COMMA);
                break;
            }
            case 46: {
                token = new Token(TokenType.DOT);
                break;
            }
            case 43: {
                token = new Token(TokenType.PLUS);
                break;
            }
            case 45: {
                token = new Token(TokenType.MINUS);
                break;
            }
            case 42: {
                token = new Token(TokenType.MULTIPLY);
                break;
            }
            case 47: {
                token = new Token(TokenType.DIVIDE);
                break;
            }
            case 63: {
                token = new Token(TokenType.QUESTION);
                break;
            }
            case 58: {
                token = new Token(TokenType.COLON);
                break;
            }
            case 38: {
                int next = this.nextChar();
                if (next != 38) {
                    throw new CarrotException("Expected &&", this.reader.getPointer());
                }
                token = new Token(TokenType.LOGICAL_AND);
                break;
            }
            case 124: {
                int next = this.nextChar();
                if (next != 124) {
                    throw new CarrotException("Expected ||", this.reader.getPointer());
                }
                token = new Token(TokenType.LOGICAL_OR);
                break;
            }
            case 61: {
                int next = this.nextChar();
                if (next != 61) {
                    if (next > 0) {
                        this.lookahead = Character.valueOf((char)next);
                    }
                    token = new Token(TokenType.ASSIGNMENT);
                    break;
                }
                token = new Token(TokenType.EQUALITY);
                break;
            }
            case 33: {
                int next = this.nextChar();
                if (next != 61) {
                    this.lookahead = Character.valueOf((char)next);
                    token = new Token(TokenType.NOT);
                    break;
                }
                token = new Token(TokenType.INEQUALITY);
                break;
            }
            case 60: {
                int next = this.nextChar();
                if (next != 61) {
                    if (next > 0) {
                        this.lookahead = Character.valueOf((char)next);
                    }
                    token = new Token(TokenType.LESS_THAN);
                    break;
                }
                token = new Token(TokenType.LESS_THAN_OR_EQUAL);
                break;
            }
            case 62: {
                int next = this.nextChar();
                if (next != 61) {
                    if (next > 0) {
                        this.lookahead = Character.valueOf((char)next);
                    }
                    token = new Token(TokenType.GREATER_THAN);
                    break;
                }
                token = new Token(TokenType.GREATER_THAN_OR_EQUAL);
                break;
            }
            case 34: 
            case 39: {
                String str = "";
                int next = this.nextChar();
                while (next >= 0 && next != ch) {
                    str = str + (char)next;
                    next = this.nextChar();
                }
                if (next < 0) {
                    throw new CarrotException("Unexpected end-of-file waiting for " + (char)ch, this.reader.getPointer());
                }
                token = new Token(TokenType.STRING_LITERAL, str);
                break;
            }
            default: {
                if ("0123456789".indexOf(ch) >= 0) {
                    String number = "";
                    number = number + (char)ch;
                    int next = this.nextChar();
                    while (next >= 0 && "0123456789.".indexOf(next) >= 0) {
                        number = number + (char)next;
                        next = this.nextChar();
                    }
                    if (next >= 0) {
                        this.lookahead = Character.valueOf((char)next);
                    }
                    Number value = number.contains(".") ? (Number)Double.parseDouble(number) : (Number)Long.parseLong(number);
                    token = new Token(TokenType.NUMBER_LITERAL, value);
                    break;
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    String identifier = "";
                    identifier = identifier + (char)ch;
                    int next = this.nextChar();
                    while (next > 0 && Character.isJavaIdentifierPart(next)) {
                        identifier = identifier + (char)next;
                        next = this.nextChar();
                    }
                    if (next > 0) {
                        this.lookahead = Character.valueOf((char)next);
                    }
                    switch (identifier) {
                        case "or": {
                            token = new Token(TokenType.LOGICAL_OR);
                            break block0;
                        }
                        case "and": {
                            token = new Token(TokenType.LOGICAL_AND);
                            break block0;
                        }
                        case "not": {
                            token = new Token(TokenType.NOT);
                            break block0;
                        }
                        case "in": {
                            token = new Token(TokenType.IN);
                            break block0;
                        }
                    }
                    token = new Token(TokenType.IDENTIFIER, identifier);
                    break;
                }
                throw new CarrotException("Unexpected character: " + (char)ch, this.reader.getPointer());
            }
        }
        this.tokens.add(token);
    }

    private int nextChar() throws CarrotException {
        try {
            int ch;
            if (this.lookahead != null) {
                ch = this.lookahead.charValue();
                this.lookahead = null;
            } else {
                ch = this.reader.nextChar();
            }
            return ch;
        }
        catch (IOException e) {
            throw new CarrotException(e);
        }
    }
}

