/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.expr.binary.AddOperator;
import au.com.codeka.carrot.expr.binary.AndOperator;
import au.com.codeka.carrot.expr.binary.BinaryOperator;
import au.com.codeka.carrot.expr.binary.Complement;
import au.com.codeka.carrot.expr.binary.DivOperator;
import au.com.codeka.carrot.expr.binary.EqOperator;
import au.com.codeka.carrot.expr.binary.GreaterOperator;
import au.com.codeka.carrot.expr.binary.InOperator;
import au.com.codeka.carrot.expr.binary.IterationOperator;
import au.com.codeka.carrot.expr.binary.LessOperator;
import au.com.codeka.carrot.expr.binary.MulOperator;
import au.com.codeka.carrot.expr.binary.OrOperator;
import au.com.codeka.carrot.expr.binary.SubOperator;
import au.com.codeka.carrot.expr.ternary.ComparisonOperator;
import au.com.codeka.carrot.expr.ternary.TernaryOperator;
import au.com.codeka.carrot.expr.unary.MinusOperator;
import au.com.codeka.carrot.expr.unary.NotOperator;
import au.com.codeka.carrot.expr.unary.PlusOperator;
import au.com.codeka.carrot.expr.unary.UnaryOperator;

public enum TokenType {
    EOF(false),
    STRING_LITERAL(true),
    NUMBER_LITERAL(true),
    IDENTIFIER(true),
    RPAREN(false),
    LPAREN(false, RPAREN),
    RSQUARE(false),
    LSQUARE(false, RSQUARE),
    ASSIGNMENT(false),
    COMMA(false, new IterationOperator()),
    DOT(false),
    NOT(false, null, new NotOperator()),
    LOGICAL_AND(false, new AndOperator()),
    LOGICAL_OR(false, new OrOperator()),
    EQUALITY(false, new EqOperator()),
    INEQUALITY(false, new Complement(TokenType.EQUALITY.binaryOperator)),
    LESS_THAN(false, new LessOperator()),
    GREATER_THAN(false, new GreaterOperator()),
    LESS_THAN_OR_EQUAL(false, new Complement(TokenType.GREATER_THAN.binaryOperator)),
    GREATER_THAN_OR_EQUAL(false, new Complement(TokenType.LESS_THAN.binaryOperator)),
    PLUS(false, new AddOperator(), new PlusOperator()),
    MINUS(false, new SubOperator(), new MinusOperator()),
    MULTIPLY(false, new MulOperator()),
    DIVIDE(false, new DivOperator()),
    IN(false, new InOperator()),
    COLON(false),
    QUESTION(new ComparisonOperator(), COLON);

    private final boolean hasValue;
    private final BinaryOperator binaryOperator;
    private final UnaryOperator unaryOperator;
    private final TernaryOperator ternaryOperator;
    private final TokenType closingToken;

    private TokenType(boolean hasValue) {
        this(hasValue, null, null, null, null);
    }

    private TokenType(boolean hasValue, TokenType closingToken) {
        this(hasValue, null, null, null, closingToken);
    }

    private TokenType(TernaryOperator ternaryOperator, TokenType separatorToken) {
        this(false, ternaryOperator, null, null, separatorToken);
    }

    private TokenType(boolean hasValue, BinaryOperator binaryOperator) {
        this(hasValue, null, binaryOperator, null, null);
    }

    private TokenType(boolean hasValue, BinaryOperator binaryOperator, UnaryOperator unaryOperator) {
        this(hasValue, null, binaryOperator, unaryOperator, null);
    }

    private TokenType(boolean hasValue, TernaryOperator ternaryOperator, BinaryOperator binaryOperator, UnaryOperator unaryOperator, TokenType closingToken) {
        this.hasValue = hasValue;
        this.ternaryOperator = ternaryOperator;
        this.binaryOperator = binaryOperator;
        this.unaryOperator = unaryOperator;
        this.closingToken = closingToken;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public TernaryOperator ternaryOperator() {
        if (this.ternaryOperator == null) {
            throw new UnsupportedOperationException(String.format("%s is not a ternary operator", this.toString()));
        }
        return this.ternaryOperator;
    }

    public BinaryOperator binaryOperator() {
        if (this.binaryOperator == null) {
            throw new UnsupportedOperationException(String.format("%s is not a binary operator", this.toString()));
        }
        return this.binaryOperator;
    }

    public UnaryOperator unaryOperator() {
        if (this.unaryOperator == null) {
            throw new UnsupportedOperationException(String.format("%s is not an unary operator", this.toString()));
        }
        return this.unaryOperator;
    }

    public TokenType closingType() {
        return this.closingToken;
    }

    public TokenType separatorType() {
        return this.closingToken;
    }
}

