/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.TermParser;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.Tokenizer;
import au.com.codeka.carrot.expr.accessible.AccessTermParser;
import au.com.codeka.carrot.expr.binary.BinaryTermParser;
import au.com.codeka.carrot.expr.binary.LaxIterationTermParser;
import au.com.codeka.carrot.expr.binary.StrictIterationTermParser;
import au.com.codeka.carrot.expr.ternary.TernaryTermParser;
import au.com.codeka.carrot.expr.unary.UnaryTermParser;
import au.com.codeka.carrot.expr.values.ErrorTermParser;
import au.com.codeka.carrot.expr.values.ExpressionTermParser;
import au.com.codeka.carrot.expr.values.IdentifierTermParser;
import au.com.codeka.carrot.expr.values.NumberTermParser;
import au.com.codeka.carrot.expr.values.StringTermParser;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StatementParser {
    private final Tokenizer tokenizer;
    private final TermParser expressionParser;
    private final TermParser iterableParser;
    private final TermParser strictIdentifierParser;

    public StatementParser(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.strictIdentifierParser = new IdentifierTermParser(new ErrorTermParser());
        TermParser base = new BinaryTermParser(new BinaryTermParser(new BinaryTermParser(new BinaryTermParser(new BinaryTermParser(new BinaryTermParser(new UnaryTermParser(new NumberTermParser(new StringTermParser(new ExpressionTermParser(new AccessTermParser(new TermParser(){

            @Override
            public Term parse(Tokenizer tokenizer) throws CarrotException {
                return StatementParser.this.expressionParser.parse(tokenizer);
            }
        }, this.strictIdentifierParser, new TermParser(){

            @Override
            public Term parse(Tokenizer tokenizer) throws CarrotException {
                return StatementParser.this.iterableParser.parse(tokenizer);
            }
        }), new TermParser(){

            @Override
            public Term parse(Tokenizer tokenizer) throws CarrotException {
                return StatementParser.this.expressionParser.parse(tokenizer);
            }
        }))), TokenType.NOT), TokenType.MULTIPLY, TokenType.DIVIDE), TokenType.PLUS, TokenType.MINUS), TokenType.LESS_THAN, TokenType.LESS_THAN_OR_EQUAL, TokenType.GREATER_THAN, TokenType.GREATER_THAN_OR_EQUAL, TokenType.IN), TokenType.EQUALITY, TokenType.INEQUALITY), TokenType.LOGICAL_AND), TokenType.LOGICAL_OR);
        base = new TernaryTermParser(base, base, base, TokenType.QUESTION);
        this.expressionParser = new LaxIterationTermParser(base);
        this.iterableParser = new StrictIterationTermParser(base);
    }

    public void parseEnd() throws CarrotException {
        this.tokenizer.end();
    }

    @Nullable
    public Identifier maybeParseIdentifier() throws CarrotException {
        if (this.tokenizer.accept(TokenType.IDENTIFIER)) {
            return this.parseIdentifier();
        }
        return null;
    }

    @Nonnull
    public Identifier parseIdentifier() throws CarrotException {
        return new Identifier(this.tokenizer.expect(TokenType.IDENTIFIER));
    }

    @Nonnull
    public Token parseToken(@Nonnull TokenType type) throws CarrotException {
        return this.tokenizer.expect(type);
    }

    public List<Identifier> maybeParseIdentifierList() throws CarrotException {
        if (!this.tokenizer.accept(TokenType.IDENTIFIER)) {
            return null;
        }
        return this.parseIdentifierList();
    }

    public List<Identifier> parseIdentifierList() throws CarrotException {
        LinkedList<Identifier> result = new LinkedList<Identifier>();
        result.add(new Identifier(this.tokenizer.expect(TokenType.IDENTIFIER)));
        while (this.tokenizer.accept(TokenType.COMMA)) {
            this.tokenizer.expect(TokenType.COMMA);
            result.add(new Identifier(this.tokenizer.expect(TokenType.IDENTIFIER)));
        }
        return result;
    }

    public boolean isAssignment() throws CarrotException {
        if (!this.tokenizer.accept(TokenType.ASSIGNMENT)) {
            return false;
        }
        this.tokenizer.expect(TokenType.ASSIGNMENT);
        return true;
    }

    public Term parseTerm() throws CarrotException {
        return this.expressionParser.parse(this.tokenizer);
    }

    public Term parseTermsIterable() throws CarrotException {
        return this.iterableParser.parse(this.tokenizer);
    }
}

