/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr.values;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.TermParser;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.Tokenizer;

public final class IdentifierTermParser
implements TermParser {
    private final TermParser delegate;

    public IdentifierTermParser(TermParser delegate) {
        this.delegate = delegate;
    }

    @Override
    public Term parse(Tokenizer tokenizer) throws CarrotException {
        if (!tokenizer.accept(TokenType.IDENTIFIER)) {
            return this.delegate.parse(tokenizer);
        }
        return new IdentifierTerm(tokenizer.expect(TokenType.IDENTIFIER));
    }

    private static final class IdentifierTerm
    implements Term {
        private final Token token;

        public IdentifierTerm(Token token) {
            this.token = token;
        }

        @Override
        public Object evaluate(Configuration config, Scope scope) throws CarrotException {
            return this.token.getValue().toString();
        }

        public String toString() {
            return this.token.getValue().toString();
        }
    }
}

