/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr.accessible;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.expr.LazyTerm;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.accessible.AccessOperator;
import au.com.codeka.carrot.expr.accessible.AccessibleTerm;
import au.com.codeka.carrot.expr.accessible.Callable;
import au.com.codeka.carrot.expr.binary.BinaryOperator;
import au.com.codeka.carrot.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AccessTerm
implements AccessibleTerm {
    private final AccessibleTerm left;
    private final BinaryOperator operation;
    private final Term right;
    private final TokenType accessorToken;

    public AccessTerm(AccessibleTerm left, AccessOperator operation, Term right, TokenType accessorToken) {
        this.left = left;
        this.operation = operation;
        this.right = right;
        this.accessorToken = accessorToken;
    }

    @Override
    public Object evaluate(Configuration config, Scope scope) throws CarrotException {
        return this.operation.apply(this.left.evaluate(config, scope), new LazyTerm(config, scope, this.right));
    }

    @Override
    @Nonnull
    public Callable callable(final @Nonnull Configuration config, @Nonnull Scope scope) throws CarrotException {
        final Object value = this.left.evaluate(config, scope);
        Object accessor = this.right.evaluate(config, scope);
        return new Callable(){

            @Override
            @Nullable
            public Object call(@Nonnull Iterable<Object> args) throws CarrotException {
                ArrayList paramTypes = new ArrayList();
                ArrayList<Object> paramValues = new ArrayList<Object>();
                for (Object p : args) {
                    paramTypes.add(p.getClass());
                    paramValues.add(p);
                }
                try {
                    Method method = this.findMethod(config, value.getClass(), AccessTerm.this.right.toString(), paramTypes, paramValues);
                    method.setAccessible(true);
                    return method.invoke(value, paramValues.toArray());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new CarrotException(e);
                }
            }

            private Method findMethod(Configuration config2, Class<?> cls, String name, List<Class<?>> paramTypes, List<Object> paramValues) throws CarrotException {
                ArrayList<String> candidates = new ArrayList<String>();
                for (Method method : cls.getMethods()) {
                    int i;
                    if (!method.getName().equalsIgnoreCase(name)) continue;
                    Class<?>[] methodParamTypes = method.getParameterTypes();
                    if (methodParamTypes.length != paramTypes.size()) {
                        Log.debug(config2, "Wrong number of arguments: %d: %s", paramTypes.size(), method);
                        candidates.add(method.toString());
                        continue;
                    }
                    boolean allMatch = true;
                    for (i = 0; i < methodParamTypes.length; ++i) {
                        if (methodParamTypes[i].isAssignableFrom(paramTypes.get(i))) continue;
                        Object convertedValue = this.convertType(methodParamTypes[i], paramValues.get(i));
                        if (convertedValue != null) {
                            paramValues.set(i, convertedValue);
                            continue;
                        }
                        Log.debug(config2, "Param %d (%s) not assignable from %s: %s", i, methodParamTypes[i], paramTypes.get(i), method);
                        candidates.add(method.toString());
                        allMatch = false;
                        break;
                    }
                    if (!allMatch) continue;
                    for (i = 0; i < methodParamTypes.length; ++i) {
                        paramValues.set(i, this.convertType(method.getParameterTypes()[i], paramValues.get(i)));
                    }
                    return method;
                }
                throw new CarrotException(String.format("No matching method '%s' found on class %s, candidates: %s", name, cls.getName(), candidates.toString()));
            }

            @Nullable
            private Object convertType(Class<?> outputType, Object value2) {
                if (value2 == null) {
                    throw new NullPointerException("Value cannot be null.");
                }
                if (outputType.equals(value2.getClass())) {
                    return value2;
                }
                if (outputType.isAssignableFrom(value2.getClass())) {
                    return value2;
                }
                if ((Byte.TYPE.equals(outputType) || Byte.class.equals(outputType)) && value2 instanceof Number) {
                    return ((Number)value2).byteValue();
                }
                if ((Short.TYPE.equals(outputType) || Short.class.equals(outputType)) && value2 instanceof Number) {
                    return ((Number)value2).shortValue();
                }
                if ((Integer.TYPE.equals(outputType) || Integer.class.equals(outputType)) && value2 instanceof Number) {
                    return ((Number)value2).intValue();
                }
                if ((Long.TYPE.equals(outputType) || Long.class.equals(outputType)) && value2 instanceof Number) {
                    return ((Number)value2).longValue();
                }
                if ((Float.TYPE.equals(outputType) || Float.class.equals(outputType)) && value2 instanceof Number) {
                    return Float.valueOf(((Number)value2).floatValue());
                }
                if ((Double.TYPE.equals(outputType) || Double.class.equals(outputType)) && value2 instanceof Number) {
                    return ((Number)value2).doubleValue();
                }
                return null;
            }
        };
    }

    public String toString() {
        if (this.accessorToken.closingType() == null) {
            return String.format("%s %s %s", this.left.toString(), this.accessorToken.toString(), this.right.toString());
        }
        return String.format("%s %s %s %s", this.left.toString(), this.accessorToken.toString(), this.right.toString(), this.accessorToken.closingType().toString());
    }
}

