/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot;

import au.com.codeka.carrot.Bindings;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.ParseCache;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.bindings.MapBindings;
import au.com.codeka.carrot.helpers.HtmlHelper;
import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.TemplateParser;
import au.com.codeka.carrot.tmpl.parse.Tokenizer;
import au.com.codeka.carrot.util.LineReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nullable;

public class CarrotEngine {
    private final Configuration config;
    private final MapBindings globalBindings;
    private final ParseCache parseCache;
    private final TemplateParser templateParser;

    public CarrotEngine(Configuration config) {
        this.config = config;
        this.globalBindings = MapBindings.newBuilder().set("html", new HtmlHelper()).build();
        this.parseCache = new ParseCache(config);
        this.templateParser = new TemplateParser(config);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public MapBindings getGlobalBindings() {
        return this.globalBindings;
    }

    public void process(Writer writer, ResourceName resourceName, Scope scope) throws CarrotException {
        Node node = this.parseCache.getNode(resourceName);
        if (node == null) {
            LineReader lineReader = new LineReader(resourceName, this.config.getResourceLocator().getReader(resourceName));
            node = this.templateParser.parse(new Tokenizer(lineReader));
            this.parseCache.addNode(resourceName, node);
        }
        try {
            node.render(this, writer, scope);
        }
        catch (IOException e) {
            throw new CarrotException(e, node.getPointer());
        }
    }

    public void process(Writer writer, String templateFile, @Nullable Bindings bindings) throws CarrotException {
        ResourceName resourceName = this.config.getResourceLocator().findResource(templateFile);
        Scope scope = new Scope(this.globalBindings);
        if (bindings != null) {
            scope.push(bindings);
        }
        this.process(writer, resourceName, scope);
    }

    public String process(String templateFile, @Nullable Bindings bindings) throws CarrotException {
        StringWriter writer = new StringWriter();
        this.process((Writer)writer, templateFile, bindings);
        return writer.getBuffer().toString();
    }
}

