/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.expr.Expression;
import au.com.codeka.carrot.expr.Function;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.TokenType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Variable {
    private final Identifier identifier;
    @Nullable
    private final Function function;
    @Nullable
    private final Expression accessExpression;
    @Nullable
    private final Variable dotVariable;

    public Variable(Identifier identifier, @Nullable Function function, @Nullable Expression accessExpression, @Nullable Variable dotVariable) {
        this.identifier = identifier;
        this.function = function;
        this.accessExpression = accessExpression;
        this.dotVariable = dotVariable;
    }

    public Object evaluate(Configuration config, Scope scope) throws CarrotException {
        String identifierName = this.identifier.evaluate();
        if (identifierName == null) {
            return null;
        }
        Object value = scope.resolve(identifierName);
        if (this.function != null) {
            value = this.function.evaluate(value, config, scope);
        }
        return this.evaluateRecursive(value, config, scope);
    }

    private Object evaluate(Object value, Configuration config, Scope scope) throws CarrotException {
        String accessor = this.identifier.evaluate();
        value = this.access(config, value, accessor, this.identifier.toString());
        return this.evaluateRecursive(value, config, scope);
    }

    private Object evaluateRecursive(Object value, Configuration config, Scope scope) throws CarrotException {
        if (this.accessExpression != null) {
            value = this.access(config, value, this.accessExpression.evaluate(config, scope), this.accessExpression.toString());
        }
        if (this.dotVariable != null) {
            value = this.dotVariable.evaluate(value, config, scope);
        }
        return value;
    }

    private Object access(Configuration config, Object value, Object accessor, String debugName) throws CarrotException {
        if (value == null) {
            throw new CarrotException(debugName + " is null.");
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.get(accessor);
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.get(ValueHelper.toNumber(accessor).intValue());
        }
        if (value.getClass().isArray()) {
            return Array.get(value, ValueHelper.toNumber(accessor).intValue());
        }
        try {
            String name = accessor.toString();
            Field field = value.getClass().getField(name);
            field.setAccessible(true);
            return field.get(value);
        }
        catch (IllegalAccessException | NoSuchFieldException name) {
            try {
                String name2 = accessor.toString();
                Method method = value.getClass().getMethod(name2, new Class[0]);
                method.setAccessible(true);
                return method.invoke(value, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException name2) {
                try {
                    String name3 = accessor.toString();
                    name3 = Character.toUpperCase(name3.charAt(0)) + name3.substring(1);
                    name3 = "get" + name3;
                    Method method = value.getClass().getMethod(name3, new Class[0]);
                    method.setAccessible(true);
                    return method.invoke(value, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CarrotException(e);
                }
            }
        }
    }

    public String toString() {
        String str = this.identifier.toString();
        if (this.function != null) {
            str = str + " " + (Object)((Object)TokenType.DOT) + " " + this.function.toString();
        }
        if (this.accessExpression != null) {
            str = str + " " + (Object)((Object)TokenType.LSQUARE) + " " + this.accessExpression + " " + (Object)((Object)TokenType.RSQUARE) + " ";
        }
        if (this.dotVariable != null) {
            str = str + " " + (Object)((Object)TokenType.DOT) + " " + this.dotVariable.toString();
        }
        return str;
    }
}

