/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.expr.Expression;
import au.com.codeka.carrot.expr.NumberLiteral;
import au.com.codeka.carrot.expr.StringLiteral;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.Variable;
import javax.annotation.Nullable;

public class Factor {
    @Nullable
    private final Variable variable;
    @Nullable
    private final NumberLiteral number;
    @Nullable
    private final StringLiteral string;
    @Nullable
    private final Expression expression;

    public Factor(Variable variable) {
        this.variable = variable;
        this.number = null;
        this.string = null;
        this.expression = null;
    }

    public Factor(NumberLiteral number) {
        this.variable = null;
        this.number = number;
        this.string = null;
        this.expression = null;
    }

    public Factor(StringLiteral string) {
        this.variable = null;
        this.number = null;
        this.string = string;
        this.expression = null;
    }

    public Factor(Expression expression) {
        this.variable = null;
        this.number = null;
        this.string = null;
        this.expression = expression;
    }

    public Object evaluate(Configuration config, Scope scope) throws CarrotException {
        if (this.variable != null) {
            return this.variable.evaluate(config, scope);
        }
        if (this.number != null) {
            return this.number.evaluate();
        }
        if (this.string != null) {
            return this.string.evaluate();
        }
        if (this.expression != null) {
            return this.expression.evaluate(config, scope);
        }
        throw new CarrotException("Everything is null.");
    }

    public String toString() {
        if (this.variable != null) {
            return this.variable.toString();
        }
        if (this.number != null) {
            return this.number.toString();
        }
        if (this.string != null) {
            return this.string.toString();
        }
        if (this.expression != null) {
            return (Object)((Object)TokenType.LPAREN) + " " + this.expression.toString() + " " + (Object)((Object)TokenType.RPAREN);
        }
        throw new IllegalStateException("Everything is null.");
    }
}

