/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class Comparator {
    private final ArrayList<PrefixedTerm> prefixedTerms;

    private Comparator(ArrayList<PrefixedTerm> prefixedTerms) {
        this.prefixedTerms = prefixedTerms;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PrefixedTerm prefixedTerm : this.prefixedTerms) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (prefixedTerm.prefix != null) {
                sb.append(prefixedTerm.prefix);
                sb.append(" ");
            }
            sb.append(prefixedTerm.term);
        }
        return sb.toString();
    }

    public Object evaluate(Configuration config, Scope scope) throws CarrotException {
        Object value = this.prefixedTerms.get((int)0).term.evaluate(config, scope);
        Token prefix = this.prefixedTerms.get((int)0).prefix;
        if (prefix != null && prefix.getType() == TokenType.MINUS) {
            value = ValueHelper.negate(value);
        }
        for (int i = 1; i < this.prefixedTerms.size(); ++i) {
            Number lhs = ValueHelper.toNumber(value);
            Number rhs = ValueHelper.toNumber(this.prefixedTerms.get((int)i).term.evaluate(config, scope));
            prefix = this.prefixedTerms.get((int)i).prefix;
            if (prefix == null) {
                throw new CarrotException("Unexpected null prefix.");
            }
            if (prefix.getType() == TokenType.MINUS) {
                rhs = ValueHelper.negate(rhs);
            }
            value = ValueHelper.add(lhs, rhs);
        }
        return value;
    }

    private static class PrefixedTerm {
        @Nullable
        public Token prefix;
        public Term term;

        PrefixedTerm(@Nullable Token prefix, Term term) {
            this.prefix = prefix;
            this.term = term;
        }
    }

    public static class Builder {
        private final ArrayList<PrefixedTerm> terms = new ArrayList();

        public Builder(@Nullable Token prefix, Term term) {
            this.terms.add(new PrefixedTerm(prefix, term));
        }

        public Builder addTerm(Token prefix, Term term) {
            this.terms.add(new PrefixedTerm(prefix, term));
            return this;
        }

        public Comparator build() {
            return new Comparator(this.terms);
        }
    }
}

