/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tmpl;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.tmpl.FixedNode;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.RootNode;
import au.com.codeka.carrot.tmpl.TagNode;
import au.com.codeka.carrot.tmpl.parse.Token;
import au.com.codeka.carrot.tmpl.parse.TokenType;
import au.com.codeka.carrot.tmpl.parse.Tokenizer;

public class TemplateParser {
    private final Configuration config;

    public TemplateParser(Configuration config) {
        this.config = config;
    }

    public Node parse(Tokenizer tokenizer) throws CarrotException {
        RootNode root = new RootNode(tokenizer.getPointer());
        this.parse(tokenizer, root);
        return root;
    }

    private void parse(Tokenizer tokenizer, Node node) throws CarrotException {
        Token token;
        while ((token = tokenizer.getNextToken()) != null) {
            Node childNode;
            if (token.getType() == TokenType.COMMENT) {
                childNode = null;
            } else if (token.getType() == TokenType.ECHO) {
                childNode = TagNode.createEcho(token, this.config);
            } else if (token.getType() == TokenType.TAG) {
                TagNode tagNode = TagNode.create(token, this.config);
                if (tagNode.isEndBlock()) {
                    return;
                }
                if (node.canChain(tagNode)) {
                    node = node.chain(tagNode);
                    childNode = null;
                } else {
                    childNode = tagNode;
                }
            } else if (token.getType() == TokenType.FIXED) {
                childNode = FixedNode.create(token);
            } else {
                throw new IllegalStateException("Unknown token type: " + (Object)((Object)token.getType()));
            }
            if (childNode == null) continue;
            if (childNode.isBlockNode()) {
                this.parse(tokenizer, childNode);
            }
            node.add(childNode);
        }
        return;
    }
}

