/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.expr.Comparator;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import javax.annotation.Nullable;

public class OrCond {
    private final Comparator lhs;
    @Nullable
    private final Token operator;
    @Nullable
    private final Comparator rhs;

    public OrCond(Comparator comparator) {
        this.lhs = comparator;
        this.operator = null;
        this.rhs = null;
    }

    public OrCond(Comparator lhs, Token operator, Comparator rhs) {
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    public String toString() {
        String str = this.lhs.toString();
        if (this.operator != null && this.rhs != null) {
            str = str + " " + this.operator + " ";
            str = str + this.rhs.toString();
        }
        return str;
    }

    public Object evaluate(Configuration config, Scope scope) throws CarrotException {
        Object value = this.lhs.evaluate(config, scope);
        if (this.operator != null && this.rhs != null) {
            if (this.operator.getType() == TokenType.EQUALITY) {
                Object lhsValue = value;
                Object rhsValue = this.rhs.evaluate(config, scope);
                return lhsValue.equals(rhsValue);
            }
            throw new CarrotException("TODO");
        }
        return value;
    }
}

