/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.ParseCache;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.helpers.HtmlHelper;
import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.TemplateParser;
import au.com.codeka.carrot.tmpl.parse.Tokenizer;
import au.com.codeka.carrot.util.LineReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class CarrotEngine {
    private final Configuration config;
    private final Map<String, Object> globalBindings;
    private final ParseCache parseCache;
    private final TemplateParser templateParser;

    public CarrotEngine() {
        this(new Configuration());
    }

    public CarrotEngine(Configuration config) {
        this.config = config;
        this.globalBindings = new HashMap<String, Object>();
        this.parseCache = new ParseCache(config);
        this.templateParser = new TemplateParser(config);
        this.globalBindings.put("html", new HtmlHelper());
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Map<String, Object> getGlobalBindings() {
        return this.globalBindings;
    }

    public void process(Writer writer, ResourceName resourceName, Scope scope) throws CarrotException {
        Node node = this.parseCache.getNode(resourceName);
        if (node == null) {
            LineReader lineReader = new LineReader(resourceName, this.config.getResourceLocater().getReader(resourceName));
            node = this.templateParser.parse(new Tokenizer(lineReader));
            this.parseCache.addNode(resourceName, node);
        }
        try {
            node.render(this, writer, scope);
        }
        catch (IOException e) {
            throw new CarrotException(e, node.getPointer());
        }
    }

    public void process(Writer writer, String templateFile, @Nullable Map<String, Object> bindings) throws CarrotException {
        ResourceName resourceName = this.config.getResourceLocater().findResource(templateFile);
        Scope scope = new Scope(this.globalBindings);
        if (bindings != null) {
            scope.push(bindings);
        }
        this.process(writer, resourceName, scope);
    }

    public String process(String templateFile, @Nullable Map<String, Object> bindings) throws CarrotException {
        StringWriter writer = new StringWriter();
        this.process((Writer)writer, templateFile, bindings);
        return writer.getBuffer().toString();
    }
}

