/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tmpl;

import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.resource.ResourcePointer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class Node {
    @Nullable
    private final List<Node> children;
    @Nullable
    private Node nextNode;
    private ResourcePointer ptr;

    protected Node(ResourcePointer ptr, boolean isBlockNode) {
        this.ptr = ptr;
        this.children = isBlockNode ? new ArrayList<Node>() : null;
    }

    public void add(Node child) {
        if (this.children == null) {
            throw new IllegalStateException("Cannot add children to non-block nodes");
        }
        this.children.add(child);
    }

    @Nullable
    public List<Node> getChildren() {
        return this.children;
    }

    public boolean isBlockNode() {
        return this.children != null;
    }

    public boolean canChain(Node node) {
        return false;
    }

    public Node chain(Node nextNode) {
        if (!this.canChain(nextNode)) {
            throw new IllegalStateException("Cannot chain to the next node: " + nextNode);
        }
        this.nextNode = nextNode;
        return nextNode;
    }

    @Nullable
    public Node getNextNode() {
        return this.nextNode;
    }

    public ResourcePointer getPointer() {
        return this.ptr;
    }

    public abstract void render(CarrotEngine var1, Writer var2, Scope var3) throws CarrotException, IOException;

    public void renderChildren(CarrotEngine engine, Writer writer, Scope scope) throws CarrotException, IOException {
        if (this.children == null) {
            throw new IllegalStateException("Cannot call renderChildren on non-block node.");
        }
        for (Node child : this.children) {
            try {
                child.render(engine, writer, scope);
            }
            catch (Exception e) {
                if (e instanceof CarrotException) {
                    if (((CarrotException)e).getPointer() == null) {
                        throw new CarrotException(e, child.getPointer());
                    }
                    throw e;
                }
                throw new CarrotException(e, child.getPointer());
            }
        }
    }
}

