/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tag;

import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.expr.Expression;
import au.com.codeka.carrot.expr.StatementParser;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.TagNode;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class BlockTag
extends Tag {
    private Expression blockNameExpr;

    @Override
    public boolean isBlockTag() {
        return true;
    }

    @Override
    public void parseStatement(StatementParser statementParser) throws CarrotException {
        this.blockNameExpr = statementParser.parseExpression();
    }

    @Override
    public void render(CarrotEngine engine, Writer writer, TagNode tagNode, Scope scope) throws CarrotException, IOException {
        Node otherBlockTagNode = null;
        Map blocksObj = (Map)scope.resolve("__blocks");
        if (blocksObj != null) {
            otherBlockTagNode = (TagNode)blocksObj.get(this.getBlockName(engine, scope));
        }
        if (otherBlockTagNode != null) {
            otherBlockTagNode.renderChildren(engine, writer, scope);
        } else {
            tagNode.renderChildren(engine, writer, scope);
        }
    }

    public String getBlockName(CarrotEngine carrotEngine, Scope scope) throws CarrotException {
        return this.blockNameExpr.evaluate(carrotEngine.getConfig(), scope).toString();
    }
}

