/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.expr.TokenType;
import java.util.Objects;
import javax.annotation.Nullable;

public class Token {
    private final TokenType tokenType;
    @Nullable
    private final Object value;

    public Token(TokenType tokenType) {
        this.tokenType = tokenType;
        this.value = null;
    }

    public Token(TokenType tokenType, Object value) {
        this.tokenType = tokenType;
        this.value = value;
    }

    public TokenType getType() {
        return this.tokenType;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        String str = this.tokenType.toString();
        if (this.tokenType.hasValue()) {
            str = str + " <" + this.value + ">";
        }
        return str;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Token)) {
            return false;
        }
        Token otherToken = (Token)other;
        if (otherToken.tokenType != this.tokenType) {
            return false;
        }
        if (this.tokenType.hasValue()) {
            return Objects.equals(otherToken.value, this.value);
        }
        return true;
    }

    public int hashCode() {
        if (this.tokenType.hasValue()) {
            return Objects.hash(new Object[]{this.tokenType, this.value});
        }
        return this.tokenType.hashCode();
    }
}

