/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.expr.AndCond;
import au.com.codeka.carrot.expr.Comparator;
import au.com.codeka.carrot.expr.Expression;
import au.com.codeka.carrot.expr.Factor;
import au.com.codeka.carrot.expr.Function;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.NotCond;
import au.com.codeka.carrot.expr.NumberLiteral;
import au.com.codeka.carrot.expr.OrCond;
import au.com.codeka.carrot.expr.StringLiteral;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.Tokenizer;
import au.com.codeka.carrot.expr.Variable;
import javax.annotation.Nullable;

public class StatementParser {
    private final Tokenizer tokenizer;

    public StatementParser(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void parseEnd() throws CarrotException {
        this.tokenizer.end();
    }

    @Nullable
    public Identifier maybeParseIdentifier() throws CarrotException {
        if (this.tokenizer.accept(TokenType.IDENTIFIER)) {
            return this.parseIdentifier();
        }
        return null;
    }

    public Identifier parseIdentifier() throws CarrotException {
        return new Identifier(this.tokenizer.expect(TokenType.IDENTIFIER));
    }

    public NumberLiteral parseNumber() throws CarrotException {
        return new NumberLiteral(this.tokenizer.expect(TokenType.NUMBER_LITERAL));
    }

    public StringLiteral parseString() throws CarrotException {
        return new StringLiteral(this.tokenizer.expect(TokenType.STRING_LITERAL));
    }

    public Expression parseExpression() throws CarrotException {
        boolean not = false;
        if (this.tokenizer.accept(TokenType.NOT)) {
            not = true;
        }
        return new Expression(not, this.parseNotCond());
    }

    NotCond parseNotCond() throws CarrotException {
        NotCond.Builder notCondBuilder = new NotCond.Builder(this.parseAndCond());
        while (this.tokenizer.accept(TokenType.LOGICAL_AND)) {
            this.tokenizer.expect(TokenType.LOGICAL_AND);
            notCondBuilder.addAndCond(this.parseAndCond());
        }
        return notCondBuilder.build();
    }

    AndCond parseAndCond() throws CarrotException {
        AndCond.Builder andCondBuilder = new AndCond.Builder(this.parseOrCond());
        while (this.tokenizer.accept(TokenType.LOGICAL_OR)) {
            this.tokenizer.expect(TokenType.LOGICAL_OR);
            andCondBuilder.addOrCond(this.parseOrCond());
        }
        return andCondBuilder.build();
    }

    OrCond parseOrCond() throws CarrotException {
        Comparator lhs = this.parseComparator();
        TokenType[] validTypes = new TokenType[]{TokenType.EQUALITY, TokenType.INEQUALITY, TokenType.LESS_THAN, TokenType.LESS_THAN_OR_EQUAL, TokenType.GREATER_THAN_OR_EQUAL, TokenType.GREATER_THAN};
        if (this.tokenizer.accept(validTypes)) {
            Token operator = this.tokenizer.expect(validTypes);
            Comparator rhs = this.parseComparator();
            return new OrCond(lhs, operator, rhs);
        }
        return new OrCond(lhs);
    }

    Variable parseVariable() throws CarrotException {
        Identifier ident = this.parseIdentifier();
        Expression accessExpression = null;
        Variable dotVariable = null;
        Function args = null;
        if (this.tokenizer.accept(0, TokenType.DOT) && this.tokenizer.accept(1, TokenType.IDENTIFIER) && this.tokenizer.accept(2, TokenType.LPAREN)) {
            this.tokenizer.expect(TokenType.DOT);
            Identifier funcNameIdentifier = this.parseIdentifier();
            this.tokenizer.expect(TokenType.LPAREN);
            Function.Builder argsBuilder = new Function.Builder(funcNameIdentifier);
            boolean first = true;
            while (!this.tokenizer.accept(TokenType.RPAREN)) {
                if (!first) {
                    this.tokenizer.expect(TokenType.COMMA);
                }
                first = false;
                Expression expr = this.parseExpression();
                argsBuilder.addParam(expr);
            }
            this.tokenizer.expect(TokenType.RPAREN);
            args = argsBuilder.build();
        }
        if (this.tokenizer.accept(TokenType.LSQUARE)) {
            this.tokenizer.expect(TokenType.LSQUARE);
            accessExpression = this.parseExpression();
            this.tokenizer.expect(TokenType.RSQUARE);
        }
        if (this.tokenizer.accept(TokenType.DOT)) {
            this.tokenizer.expect(TokenType.DOT);
            dotVariable = this.parseVariable();
        }
        return new Variable(ident, args, accessExpression, dotVariable);
    }

    Factor parseFactor() throws CarrotException {
        if (this.tokenizer.accept(TokenType.LPAREN)) {
            this.tokenizer.expect(TokenType.LPAREN);
            Expression expr = this.parseExpression();
            this.tokenizer.expect(TokenType.RPAREN);
            return new Factor(expr);
        }
        if (this.tokenizer.accept(TokenType.STRING_LITERAL)) {
            return new Factor(this.parseString());
        }
        if (this.tokenizer.accept(TokenType.NUMBER_LITERAL)) {
            return new Factor(this.parseNumber());
        }
        if (this.tokenizer.accept(TokenType.IDENTIFIER)) {
            return new Factor(this.parseVariable());
        }
        throw this.tokenizer.unexpected("Variable, number, string or expression expected.");
    }

    Term parseTerm() throws CarrotException {
        Token prefix = this.tokenizer.accept(TokenType.MULTIPLY) || this.tokenizer.accept(TokenType.DIVIDE) ? this.tokenizer.expect(TokenType.MULTIPLY, TokenType.DIVIDE) : null;
        Factor factor = this.parseFactor();
        Term.Builder termBuilder = new Term.Builder(prefix, factor);
        while (this.tokenizer.accept(TokenType.MULTIPLY) || this.tokenizer.accept(TokenType.DIVIDE)) {
            prefix = this.tokenizer.expect(TokenType.MULTIPLY, TokenType.DIVIDE);
            termBuilder.addFactor(prefix, this.parseFactor());
        }
        return termBuilder.build();
    }

    Comparator parseComparator() throws CarrotException {
        Token prefix = this.tokenizer.accept(TokenType.PLUS) || this.tokenizer.accept(TokenType.MINUS) ? this.tokenizer.expect(TokenType.PLUS, TokenType.MINUS) : null;
        Term term = this.parseTerm();
        Comparator.Builder exprBuilder = new Comparator.Builder(prefix, term);
        while (this.tokenizer.accept(TokenType.PLUS) || this.tokenizer.accept(TokenType.MINUS)) {
            prefix = this.tokenizer.expect(TokenType.PLUS, TokenType.MINUS);
            exprBuilder.addTerm(prefix, this.parseTerm());
        }
        return exprBuilder.build();
    }
}

