/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.util;

import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.util.VariableChain;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Variable {
    private static Pattern SPLIT_REGEX = Pattern.compile("[\\[\\]\\.]");
    private String name;
    private List<String> chainList;

    public Variable(String variable) {
        this.split(variable);
    }

    private void split(String variable) {
        String[] parts = SPLIT_REGEX.split(variable);
        if (parts.length == 1) {
            this.name = variable;
            this.chainList = null;
        } else {
            this.name = parts[0];
            this.chainList = new ArrayList<String>();
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i].trim();
                if (part.isEmpty()) continue;
                this.chainList.add(part);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Object resolve(Object value) throws CarrotException {
        if (this.chainList != null) {
            return new VariableChain(this.chainList, value).resolve();
        }
        return value;
    }

    public String toString() {
        return "<Variable: " + this.name + ">";
    }
}

