/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.util;

import au.com.codeka.carrot.base.Configuration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Log {
    private Configuration config;

    public Log(Configuration config) {
        this.config = config;
    }

    public void write(int level, String msg) {
        this.config.getLogger().write(level, msg);
    }

    public void debug(String fmt, Object ... args) {
        this.write(0, String.format(fmt, args));
    }

    public void info(String fmt, Object ... args) {
        this.write(1, String.format(fmt, args));
    }

    public void warn(String fmt, Object ... args) {
        this.write(2, String.format(fmt, args));
    }

    public static class DefaultLogger
    implements Configuration.Logger {
        private Logger logger = Logger.getLogger("carrot");

        @Override
        public void write(int level, String msg) {
            Level javaLevel = Level.FINE;
            switch (level) {
                case 0: {
                    javaLevel = Level.FINE;
                    break;
                }
                case 1: {
                    javaLevel = Level.INFO;
                    break;
                }
                case 2: {
                    javaLevel = Level.WARNING;
                }
            }
            this.logger.log(javaLevel, msg);
        }
    }
}

