/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tree;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.lib.Filter;
import au.com.codeka.carrot.parse.EchoToken;
import au.com.codeka.carrot.tree.Node;
import au.com.codeka.carrot.util.ObjectValue;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class VariableNode
extends Node {
    private static final long serialVersionUID = 1L;
    private EchoToken master;
    static final String name = "Variable_Node";

    public VariableNode(Application app, EchoToken token) {
        super(app);
        this.master = token;
    }

    @Override
    public void render(CarrotInterpreter interpreter, Writer writer) throws CarrotException, IOException {
        interpreter.setLevel(this.level);
        Object var = interpreter.retraceVariable(this.master.getVariable());
        List<String> filters = this.master.getFilters();
        if (filters.isEmpty()) {
            writer.write(ObjectValue.printable(var));
            return;
        }
        List<String[]> argss = this.master.getArgss();
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = (Filter)this.app.getConfiguration().getFilterLibrary().fetch(filters.get(i));
            String[] args = argss.get(i);
            var = args == null ? filter.filter(var, interpreter, new String[0]) : filter.filter(var, interpreter, args);
        }
        writer.write(ObjectValue.printable(var));
    }

    public String toString() {
        return this.master.toString();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Node clone() {
        VariableNode clone = new VariableNode(this.app, this.master);
        clone.children = this.children.clone(clone);
        return clone;
    }
}

