/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tree;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.base.Configuration;
import au.com.codeka.carrot.parse.ParseException;
import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.tree.MacroNode;
import au.com.codeka.carrot.tree.Node;
import au.com.codeka.carrot.tree.NodeAction;
import au.com.codeka.carrot.tree.NodeList;
import au.com.codeka.carrot.tree.TreeIterator;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TreeRebuilder {
    private final ResourceName currResource;
    private final Application application;
    private final Map<String, Node> capture = new HashMap<String, Node>();
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final LinkedList<Method> actions = new LinkedList();
    private List<Object[]> msgs = new LinkedList<Object[]>();
    public Node parent = null;

    public TreeRebuilder(Application application) {
        this.application = application;
        this.currResource = null;
    }

    TreeRebuilder(Application application, ResourceName currResource) {
        this.application = application;
        this.currResource = currResource;
    }

    public TreeRebuilder derive() {
        TreeRebuilder tr = new TreeRebuilder(this.application, this.currResource);
        tr.capture.putAll(this.capture);
        tr.variables.putAll(this.variables);
        tr.parent = this.parent;
        return tr;
    }

    public String resolveString(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        if (string.startsWith("\"") || string.startsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public ResourceName getWorkspace() {
        if (this.currResource == null) {
            return null;
        }
        return this.currResource.getParent();
    }

    public void assignNode(String key, Node node) {
        this.capture.put(key, node);
    }

    public Node fetchNode(String key) {
        return this.capture.get(key);
    }

    public void assignVariable(String key, Object value) {
        this.variables.put(key, value);
    }

    public Object fetchVariable(String key, Object value) {
        return this.variables.get(key);
    }

    public Configuration getConfiguration() {
        return this.application.getConfiguration();
    }

    public Application getApplication() {
        return this.application;
    }

    public Node refactor(Node root) throws ParseException {
        boolean needRelevel = false;
        TreeIterator nit = new TreeIterator(root);
        Node temp = null;
        while (nit.hasNext()) {
            temp = nit.next();
            if (!(temp instanceof MacroNode)) continue;
            ((MacroNode)temp).refactor(this);
            needRelevel = true;
        }
        if (!this.actions.isEmpty()) {
            Iterator<Object[]> it = this.msgs.iterator();
            try {
                for (Method action : this.actions) {
                    Object[] msg = it.next();
                    action.invoke(null, msg);
                }
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        if (this.parent != null) {
            root = this.parent;
        }
        if (needRelevel) {
            root.computeLevel(0);
        }
        return root;
    }

    public void nodeReplace(Node tobe, NodeList with) throws ParseException {
        if (tobe != null) {
            try {
                Method action = NodeAction.class.getDeclaredMethod("replace", Node.class, NodeList.class);
                Object[] msg = new Object[]{tobe, with};
                this.actions.add(action);
                this.msgs.add(msg);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public void nodeReplace(Node tobe, Node with) throws ParseException {
        if (tobe != null) {
            try {
                Method action = NodeAction.class.getDeclaredMethod("replace", Node.class, Node.class);
                Object[] msg = new Object[]{tobe, with};
                this.actions.add(action);
                this.msgs.add(msg);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public void nodeRemove(Node node) throws ParseException {
        if (node != null) {
            try {
                Method action = NodeAction.class.getDeclaredMethod("remove", Node.class);
                Object[] msg = new Object[]{node};
                this.actions.add(action);
                this.msgs.add(msg);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public void nodeInsertAfter(Node node, Node toAdd) throws ParseException {
        if (node != null && toAdd != null) {
            try {
                Method action = NodeAction.class.getDeclaredMethod("insertAfter", Node.class, Node.class);
                Object[] msg = new Object[]{node, toAdd};
                this.actions.add(action);
                this.msgs.add(msg);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public void nodeInsertBefore(Node node, Node toAdd) throws ParseException {
        if (node != null && toAdd != null) {
            try {
                Method action = NodeAction.class.getDeclaredMethod("insertBefore", Node.class, Node.class);
                Object[] msg = new Object[]{node, toAdd};
                this.actions.add(action);
                this.msgs.add(msg);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public void nodeAddChildLast(Node parent, Node toAdd) throws ParseException {
        if (parent != null && toAdd != null) {
            try {
                Method action = NodeAction.class.getDeclaredMethod("addChildLast", Node.class, Node.class);
                Object[] msg = new Object[]{parent, toAdd};
                this.actions.add(action);
                this.msgs.add(msg);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public void nodeAddChildFirst(Node parent, Node toAdd) throws ParseException {
        if (parent != null && toAdd != null) {
            try {
                Method action = NodeAction.class.getDeclaredMethod("addChildFirst", Node.class, Node.class);
                Object[] msg = new Object[]{parent, toAdd};
                this.actions.add(action);
                this.msgs.add(msg);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public void nodeExchange(Node node1, Node node2) throws ParseException {
        if (node1 != null && node2 != null) {
            try {
                Method action = NodeAction.class.getDeclaredMethod("exchange", Node.class, Node.class);
                Object[] msg = new Object[]{node1, node2};
                this.actions.add(action);
                this.msgs.add(msg);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }
}

