/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tree;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.parse.ParseException;
import au.com.codeka.carrot.parse.TokenParser;
import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.tree.Node;
import au.com.codeka.carrot.tree.TreeParser;
import au.com.codeka.carrot.tree.TreeRebuilder;
import au.com.codeka.carrot.util.Log;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

public class ParseResultManager {
    private final ConcurrentHashMap<ResourceName, NodeContainer> cache;
    private final Application application;
    private final Log log;

    public ParseResultManager(Application application) {
        this.application = application;
        this.cache = application.getConfiguration().isParseCacheEnabled() ? new ConcurrentHashMap() : null;
        this.log = new Log(application.getConfiguration());
    }

    public Node getParseResult(ResourceName resourceName) throws IOException, ParseException {
        if (this.cache == null) {
            return this.createNode(resourceName);
        }
        Node root = null;
        NodeContainer container = this.cache.get(resourceName);
        long modifiedTime = this.application.getConfiguration().getResourceLocater().getModifiedTime(resourceName);
        if (container != null) {
            root = container.node.get();
            if (root != null) {
                if (container.lastModifiedTime != modifiedTime) {
                    this.log.info("Resource has been modified, reloading: %s", resourceName.getName());
                    root = null;
                }
            } else {
                this.log.info("Resource has been garbage-collected, reloading: %s", resourceName.getName());
            }
        } else {
            this.log.info("Resource not cached, loading: %s", resourceName.getName());
        }
        if (root == null) {
            root = this.createNode(resourceName);
            this.cache.put(resourceName, new NodeContainer(root, modifiedTime));
        }
        return root;
    }

    private Node createNode(ResourceName resourceName) throws IOException, ParseException {
        Node root = new TreeParser(this.application).parse(new TokenParser(this.application.getConfiguration().getResourceLocater().getString(resourceName)));
        root = new TreeRebuilder(this.application, resourceName).refactor(root);
        return root;
    }

    private static class NodeContainer {
        public SoftReference<Node> node;
        public long lastModifiedTime;

        public NodeContainer(Node node, long lastModifiedTime) {
            this.node = new SoftReference<Node>(node);
            this.lastModifiedTime = lastModifiedTime;
        }
    }
}

